/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u00020/2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u00101\u001a\u00020/J\u0014\u00102\u001a\u00020/2\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0002J\b\u00105\u001a\u00020/H\u0002J\b\u00106\u001a\u00020/H\u0002J\b\u00107\u001a\u00020/H\u0002J\u0006\u00108\u001a\u00020/J\u0012\u0010\u001b\u001a\u00020/2\b\u00109\u001a\u0004\u0018\u00010:H\u0002J\u0012\u0010\u001f\u001a\u00020/2\b\u0010;\u001a\u0004\u0018\u00010:H\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006<"}, d2={"LDemoRunner;", "", "sink", "LBufRenderer;", "fps", "", "audio", "LAudioOutput;", "timestamp", "", "(LBufRenderer;ILAudioOutput;Z)V", "getAudio", "()LAudioOutput;", "conn", "LNetworkConnection;", "getConn", "()LNetworkConnection;", "setConn", "(LNetworkConnection;)V", "console", "LDemoRunnerConsole;", "getConsole", "()LDemoRunnerConsole;", "effect", "LEffect;", "getEffect", "()LEffect;", "setEffect", "(LEffect;)V", "getFps", "()I", "setFps", "(I)V", "lastEffectNum", "getLastEffectNum", "setLastEffectNum", "getSink", "()LBufRenderer;", "thread", "LEffectThread;", "getThread", "()LEffectThread;", "setThread", "(LEffectThread;)V", "getTimestamp", "()Z", "commandLoop", "", "ensureEffectThread", "keyPressed", "listEffects", "page", "LTeletextPage;", "nextEffectInRunner", "prevEffectInRunner", "quit", "run", "numString", "", "fpsString", "teletext-tools"})
public final class DemoRunner {
    @NotNull
    private final BufRenderer sink;
    private int fps;
    @Nullable
    private final AudioOutput audio;
    private final boolean timestamp;
    @Nullable
    private NetworkConnection conn;
    @Nullable
    private EffectThread thread;
    @Nullable
    private Effect effect;
    private int lastEffectNum;
    @NotNull
    private final DemoRunnerConsole console;

    public DemoRunner(@NotNull BufRenderer sink, int fps, @Nullable AudioOutput audio, boolean timestamp) {
        Intrinsics.checkNotNullParameter(sink, "sink");
        this.sink = sink;
        this.fps = fps;
        this.audio = audio;
        this.timestamp = timestamp;
        this.console = new DemoRunnerConsole(this);
    }

    @NotNull
    public final BufRenderer getSink() {
        return this.sink;
    }

    public final int getFps() {
        return this.fps;
    }

    public final void setFps(int n) {
        this.fps = n;
    }

    @Nullable
    public final AudioOutput getAudio() {
        return this.audio;
    }

    public final boolean getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public final NetworkConnection getConn() {
        return this.conn;
    }

    public final void setConn(@Nullable NetworkConnection networkConnection) {
        this.conn = networkConnection;
    }

    @Nullable
    public final EffectThread getThread() {
        return this.thread;
    }

    public final void setThread(@Nullable EffectThread effectThread) {
        this.thread = effectThread;
    }

    @Nullable
    public final Effect getEffect() {
        return this.effect;
    }

    public final void setEffect(@Nullable Effect effect) {
        this.effect = effect;
    }

    public final int getLastEffectNum() {
        return this.lastEffectNum;
    }

    public final void setLastEffectNum(int n) {
        this.lastEffectNum = n;
    }

    @NotNull
    public final DemoRunnerConsole getConsole() {
        return this.console;
    }

    public final void run() {
        this.ensureEffectThread(this.console, this.fps);
        System.out.println((Object)"Activate Teletext now.");
        System.out.println();
        this.commandLoop();
    }

    private final void commandLoop() {
        this.listEffects(this.console.getPage());
        System.out.println();
        Object cmd = null;
        this.ensureEffectThread(new DemoScript(this.audio, this.timestamp), this.fps);
    }

    private final void prevEffectInRunner() {
        block1: {
            Object object;
            Object object2 = this.thread;
            if (object2 == null || (object2 = ((EffectThread)object2).getEffect()) == null) break block1;
            Object it = object = object2;
            boolean bl = false;
            object2 = it instanceof DemoScript ? object : null;
            if (object2 != null) {
                it = object2;
                boolean bl2 = false;
                ((DemoScript)it).goBack();
            }
        }
    }

    private final void nextEffectInRunner() {
        block1: {
            Object object;
            Object object2 = this.thread;
            if (object2 == null || (object2 = ((EffectThread)object2).getEffect()) == null) break block1;
            Object it = object = object2;
            boolean bl = false;
            object2 = it instanceof DemoScript ? object : null;
            if (object2 != null) {
                it = object2;
                boolean bl2 = false;
                ((DemoScript)it).goForward();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void listEffects(TeletextPage page) {
        System.out.println((Object)"Available effects:");
        Iterable $this$forEachIndexed$iv = MainKt.getAllEffects();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void effect;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Effect effect2 = (Effect)item$iv;
            int index = n;
            boolean bl = false;
            String string = " %2d - %s";
            Object[] objectArray = new Object[]{index, effect.getName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
            string = string2;
            System.out.println((Object)string);
            TeletextPage teletextPage = page;
            if (teletextPage == null) continue;
            string = "%2d %s";
            objectArray = new Object[]{index, effect.getName()};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(this, *args)");
            teletextPage.drawString(0, index + 3, string3);
        }
    }

    static /* synthetic */ void listEffects$default(DemoRunner demoRunner, TeletextPage teletextPage, int n, Object object) {
        if ((n & 1) != 0) {
            teletextPage = null;
        }
        demoRunner.listEffects(teletextPage);
    }

    private final void setEffect(String numString) {
        CharSequence charSequence;
        if (numString == null || !new Regex("[0-9]+").matches(charSequence = (CharSequence)numString)) {
            System.out.println((Object)("effect " + numString + " ?!"));
        } else {
            Effect effect = CollectionsKt.getOrNull(MainKt.getAllEffects(), Integer.parseInt(numString));
            if (effect == null) {
                System.out.println((Object)("No such effect: " + numString));
            } else {
                this.ensureEffectThread(effect, this.fps);
                this.lastEffectNum = Integer.parseInt(numString);
            }
        }
    }

    private final void setFps(String fpsString) {
        CharSequence charSequence;
        if (fpsString == null || !new Regex("[0-9]+").matches(charSequence = (CharSequence)fpsString)) {
            System.out.println((Object)("fps " + fpsString + " ?!"));
        } else {
            int fps = Integer.parseInt(fpsString);
            EffectThread effectThread = this.thread;
            if (effectThread != null) {
                effectThread.setFps(fps);
            }
            this.fps = fps;
            System.out.println((Object)("fps set to " + fps + '.'));
        }
    }

    private final void quit() {
        System.out.println((Object)"Bye.");
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final void ensureEffectThread(Effect effect, int fps) {
        this.effect = effect;
        this.fps = fps;
        EffectThread effectThread = this.thread;
        if (effectThread != null) {
            EffectThread it = effectThread;
            boolean bl = false;
            System.out.println((Object)("effect " + effect.getName() + ", " + fps + ' ' + fps));
            it.setFps(fps);
            Effect.reset$default(effect, 0.0, 1, null);
            it.setEffect(effect);
            return;
        }
        EffectThread effectThread2 = this.thread = new EffectThread(effect, this.fps, this.sink);
        if (effectThread2 != null) {
            effectThread2.start();
        }
        this.effect = effect;
        this.conn = this.conn;
    }

    public final void keyPressed() {
        block1: {
            Object object;
            Object object2 = this.thread;
            if (object2 == null || (object2 = ((EffectThread)object2).getEffect()) == null) break block1;
            Object it = object = object2;
            boolean bl = false;
            object2 = it instanceof DemoScript ? object : null;
            if (object2 != null) {
                it = object2;
                boolean bl2 = false;
                ((DemoScript)it).keyPressed();
            }
        }
    }
}

