/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"LDemoRunnerConsole;", "LEffect;", "runner", "LDemoRunner;", "(LDemoRunner;)V", "page", "LTeletextPage;", "getPage", "()LTeletextPage;", "getRunner", "()LDemoRunner;", "clear", "", "doReset", "doTick", "ticks", "", "elapsed", "", "teletext-tools"})
public final class DemoRunnerConsole
extends Effect {
    @NotNull
    private final DemoRunner runner;
    @NotNull
    private final TeletextPage page;

    public DemoRunnerConsole(@NotNull DemoRunner runner) {
        Intrinsics.checkNotNullParameter(runner, "runner");
        super("Console");
        this.runner = runner;
        this.page = new TeletextPage(null, 1, null);
    }

    @NotNull
    public final DemoRunner getRunner() {
        return this.runner;
    }

    @NotNull
    public final TeletextPage getPage() {
        return this.page;
    }

    @Override
    public void doReset() {
        this.clear();
    }

    private final void clear() {
        for (int y = 0; y < 24; ++y) {
            for (int x = 0; x < 40; ++x) {
                this.page.set(x, y, 32);
            }
        }
    }

    @Override
    public void doTick(int ticks, double elapsed) {
        this.page.drawString(0, 23, "T " + ticks);
        this.page.drawString(8, 0, " > Demo Runner <");
        this.page.drawString(0, 1, "Effects:");
        int y = 1;
        this.page.drawString(22, y++, "Settings:");
        int n = ++y;
        String string = "fps    = %d";
        Object[] objectArray = new Object[]{this.runner.getFps()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
        this.page.drawString(22, n, string2);
        int n2 = ++y;
        ++y;
        string = "target = %s";
        objectArray = new Object[]{this.runner.getSink()};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(this, *args)");
        this.page.drawString(22, n2, string3);
        int n3 = ++y;
        ++y;
        this.page.drawString(22, n3, "Commands:");
        int n4 = ++y;
        this.page.drawString(22, n4, "list");
        int n5 = ++y;
        this.page.drawString(22, n5, "effect <n>");
        int n6 = ++y;
        this.page.drawString(22, n6, "+");
        int n7 = ++y;
        this.page.drawString(22, n7, "-");
        int n8 = ++y;
        this.page.drawString(22, n8, "fps <n>");
        int n9 = ++y;
        this.page.drawString(22, n9, "stop");
        int n10 = ++y;
        this.page.drawString(22, n10, "demo");
        int n11 = ++y;
        ++y;
        this.page.drawString(22, n11, "quit");
        BuffersAndEncodingKt.formatAsPage(this.page.getData(), 256, this.getBuf());
    }
}

