/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a#\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0002\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"dither", "Ljava/awt/image/BufferedImage;", "image", "posterize", "", "findClosestPaletteColor", "LColor3i;", "match", "palette", "", "(LColor3i;[LColor3i;)LColor3i;", "teletext-tools"})
public final class DitherKt {
    @NotNull
    public static final BufferedImage dither(@NotNull BufferedImage image, boolean posterize) {
        int y;
        Intrinsics.checkNotNullParameter(image, "image");
        Color3i[] color3iArray = new Color3i[]{new Color3i(0, 0, 0), new Color3i(255, 255, 255)};
        Color3i[] palette = color3iArray;
        int width = image.getWidth();
        int height = image.getHeight();
        int n = 0;
        Color3i[][] color3iArrayArray = new Color3i[height][];
        while (n < height) {
            int n2 = n++;
            color3iArrayArray[n2] = new Color3i[width];
        }
        Color3i[][] buffer = color3iArrayArray;
        for (y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int col = image.getRGB(x, y);
                if (posterize) {
                    image.setRGB(x, y, col &= 0xFFC0C080);
                }
                buffer[y][x] = new Color3i(col);
            }
        }
        int n3 = image.getHeight();
        for (y = 0; y < n3; ++y) {
            int n4 = image.getWidth();
            for (int x = 0; x < n4; ++x) {
                Color3i color3i = buffer[y][x];
                if (color3i == null) {
                    color3i = new Color3i(0);
                }
                Color3i old = color3i;
                Color3i nem = DitherKt.findClosestPaletteColor(old, palette);
                image.setRGB(x, y, nem.toColor().getRGB());
                Color3i error = old.sub(nem);
                if (x + 1 < width) {
                    Color3i color3i2 = buffer[y][x + 1];
                    Color3i color3i3 = buffer[y][x + 1] = color3i2 != null ? color3i2.add(error.mul(0.4375)) : null;
                }
                if (x - 1 >= 0 && y + 1 < height) {
                    Color3i color3i4 = buffer[y + 1][x - 1];
                    Color3i color3i5 = buffer[y + 1][x - 1] = color3i4 != null ? color3i4.add(error.mul(0.1875)) : null;
                }
                if (y + 1 < height) {
                    Color3i color3i6 = buffer[y + 1][x];
                    Color3i color3i7 = buffer[y + 1][x] = color3i6 != null ? color3i6.add(error.mul(0.3125)) : null;
                }
                if (x + 1 >= width || y + 1 >= height) continue;
                Color3i color3i8 = buffer[y + 1][x + 1];
                buffer[y + 1][x + 1] = color3i8 != null ? color3i8.add(error.mul(0.0625)) : null;
            }
        }
        return image;
    }

    public static /* synthetic */ BufferedImage dither$default(BufferedImage bufferedImage, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return DitherKt.dither(bufferedImage, bl);
    }

    private static final Color3i findClosestPaletteColor(Color3i match, Color3i[] palette) {
        Color3i closest = palette[0];
        for (Color3i color : palette) {
            if (color.diff(match) >= closest.diff(match)) continue;
            closest = color;
        }
        return closest;
    }
}

