/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0006\u0010\r\u001a\u00020\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"PLASMA_H", "", "PLASMA_SCALE_UP_FACTOR", "PLASMA_W", "SineRND", "Lkotlin/random/Random;", "getSineRND", "()Lkotlin/random/Random;", "extractDotImages", "", "Ljava/awt/image/BufferedImage;", "filename", "", "main", "", "teletext-tools"})
public final class PlasmaKt {
    public static final int PLASMA_SCALE_UP_FACTOR = 4;
    public static final int PLASMA_W = 156;
    public static final int PLASMA_H = 96;
    @NotNull
    private static final Random SineRND = RandomKt.Random(4919);

    @NotNull
    public static final Random getSineRND() {
        return SineRND;
    }

    @NotNull
    public static final List<BufferedImage> extractDotImages(@NotNull String filename) {
        Intrinsics.checkNotNullParameter(filename, "filename");
        BufferedImage srcImage = ImageIO.read(new File(filename));
        BufferedImage image = new BufferedImage(srcImage.getWidth(), srcImage.getHeight(), 3);
        image.createGraphics().drawImage((Image)srcImage, 0, 0, null);
        int size = image.getHeight();
        int x = 0;
        List dots = new ArrayList();
        while (x + size <= image.getWidth()) {
            BufferedImage image2 = image.getSubimage(x, 0, size, size);
            if (!(image2 != null)) {
                boolean bl = false;
                String string = filename + ": subimage " + x + ",0 is null?!";
                throw new IllegalArgumentException(string.toString());
            }
            Intrinsics.checkNotNullExpressionValue(image2, "image");
            dots.add(image2);
            x += size;
        }
        if (!(!dots.isEmpty())) {
            boolean bl = false;
            String string = "no dots were found in " + filename;
            throw new IllegalArgumentException(string.toString());
        }
        return dots;
    }

    public static final void main() {
        List<BufferedImage> dots = PlasmaKt.extractDotImages("gfx/colordots.png");
        PointXY center = new PointXY(78, 48);
        MovingDot[] movingDotArray = new MovingDot[]{new MovingDot(dots.get(0), center, new SineMover(20.0, 25.3, 3.4, 5.0, 0.0, 0.0, 48, null).chain(new SineMover(19.0, 5.0, 6.4, 12.5, 0.0, 0.0, 48, null))), new MovingDot(dots.get(0), center, new SineMover(12.0, 17.0, 6.5, 4.7, 0.0, 0.0, 48, null).chain(new SineMover(17.3, 8.4, 5.7, 9.1, 0.0, 0.0, 48, null))), new MovingDot(dots.get(2), center, new SineMover(30.0, 13.5, 4.8, 2.7, 0.0, 0.0, 48, null)), new MovingDot(dots.get(2), center, new SineMover(13.0, 21.5, 4.8, 4.7, 0.0, 0.0, 48, null)), new MovingDot(dots.get(4), center, new SineMover(12.0, 11.0, 3.3, 1.9, 0.0, 0.0, 48, null).chain(new SineMover(11.0, 9.0, 6.1, 4.5, 0.0, 0.0, 48, null))), new MovingDot(dots.get(4), center, new SineMover(21.0, 24.0, 6.3, 3.9, 0.0, 0.0, 48, null))};
        List<MovingDot> movingDots = CollectionsKt.listOf(movingDotArray);
        PlasmaRenderer renderer = new PlasmaRenderer(movingDots, false, 2, null);
        ImagePanel imagePanel = new ImagePanel(renderer.getCanvasScaledUp(), 4);
        FontAndRenderingKt.showInFrame$default("moving dots", imagePanel, false, 4, null);
        TeletextFont font = FontAndRenderingKt.getTeletextFont$default(false, 1, null);
        TeletextDisplayPanel displayPanel = new TeletextDisplayPanel(font);
        FontAndRenderingKt.showInFrame$default("plasmer preview", displayPanel, false, 4, null);
        while (true) {
            renderer.tick(0.0);
            renderer.paint();
            imagePanel.repaint();
            displayPanel.render(renderer.getPage().getData());
            Thread.sleep(30L);
        }
    }

    public static /* synthetic */ void main(String[] args2) {
        PlasmaKt.main();
    }
}

