/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010+\u001a\u00020,H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0005R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006-"}, d2={"LTeletextDisplayPanel;", "LImagePanel;", "LBufRenderer;", "font", "LTeletextFont;", "(LTeletextFont;)V", "buf", "", "getBuf", "()[B", "setBuf", "([B)V", "value", "getFont", "()LTeletextFont;", "setFont", "networkSink", "LNetworkConnection;", "getNetworkSink", "()LNetworkConnection;", "setNetworkSink", "(LNetworkConnection;)V", "outputSink", "Ljava/io/OutputStream;", "getOutputSink", "()Ljava/io/OutputStream;", "setOutputSink", "(Ljava/io/OutputStream;)V", "paintListener", "LPaintListener;", "getPaintListener", "()LPaintListener;", "setPaintListener", "(LPaintListener;)V", "start", "", "getStart", "()J", "paintComponent", "", "g", "Ljava/awt/Graphics;", "render", "toString", "", "teletext-tools"})
public final class TeletextDisplayPanel
extends ImagePanel
implements BufRenderer {
    @Nullable
    private NetworkConnection networkSink;
    @Nullable
    private OutputStream outputSink;
    @Nullable
    private byte[] buf;
    private final long start;
    @Nullable
    private PaintListener paintListener;
    @NotNull
    private TeletextFont font;

    public TeletextDisplayPanel(@NotNull TeletextFont font) {
        Intrinsics.checkNotNullParameter(font, "font");
        super(font.createImage(40, 24), 0, 2, null);
        this.start = System.currentTimeMillis();
        this.font = font;
    }

    @Nullable
    public final NetworkConnection getNetworkSink() {
        return this.networkSink;
    }

    public final void setNetworkSink(@Nullable NetworkConnection networkConnection) {
        this.networkSink = networkConnection;
    }

    @Nullable
    public final OutputStream getOutputSink() {
        return this.outputSink;
    }

    public final void setOutputSink(@Nullable OutputStream outputStream) {
        this.outputSink = outputStream;
    }

    @Nullable
    public final byte[] getBuf() {
        return this.buf;
    }

    public final void setBuf(@Nullable byte[] byArray) {
        this.buf = byArray;
    }

    public final long getStart() {
        return this.start;
    }

    @Nullable
    public final PaintListener getPaintListener() {
        return this.paintListener;
    }

    public final void setPaintListener(@Nullable PaintListener paintListener) {
        this.paintListener = paintListener;
    }

    @NotNull
    public final TeletextFont getFont() {
        return this.font;
    }

    public final void setFont(@NotNull TeletextFont value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.font = value;
        super.setImage(this.font.createImage(40, 24));
        this.repaint();
    }

    @Override
    public void render(@NotNull byte[] buf) {
        Object it;
        Intrinsics.checkNotNullParameter(buf, "buf");
        this.buf = buf;
        NetworkConnection networkConnection = this.networkSink;
        if (networkConnection != null) {
            it = networkConnection;
            boolean bl = false;
            ((NetworkConnection)it).send(buf);
        }
        OutputStream outputStream = this.outputSink;
        if (outputStream != null) {
            it = outputStream;
            boolean bl = false;
            ((OutputStream)it).write(buf);
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter(g, "g");
        double elapsed = (double)(System.currentTimeMillis() - this.start) / 1000.0;
        if (this.buf != null) {
            byte[] it = this.buf;
            boolean bl = false;
            Graphics2D graphics2D = this.getImage().createGraphics();
            Intrinsics.checkNotNullExpressionValue(graphics2D, "this.image.createGraphics()");
            this.font.renderTeletextPackets(graphics2D, it, elapsed);
        }
        PaintListener paintListener = this.paintListener;
        if (paintListener != null) {
            paintListener.onPaint();
        }
        super.paintComponent(g);
    }

    @Override
    @NotNull
    public String toString() {
        return "display";
    }
}

