#define WIDTH              240
#define HEIGHT             136

#define MID_X              (WIDTH/2)
#define MID_Y              (HEIGHT/2)

#define RADIUS             40
#define RADIUS_PULSE       30

#define TIME_STEP          .05
#define PULSE_SPEED        0.5

#define POINTS_MIN         3
#define POINTS_MAX         10
#define POINTS_STEP        3

t=0
points=3

function TIC()
	for i=3,47 do
		poke(16320+i, 128 + 96*math.cos((i%3)*i/15 + i%3/3*t))
	end

	roundness=20*math.cos(t)
	pulse=math.cos(PULSE_SPEED*t)

	if (roundness>=0) ~= last_roundness_sign then
		points=POINTS_MIN + (points-POINTS_MIN+POINTS_STEP) % (POINTS_MAX - POINTS_MIN + 1)
		last_roundness_sign=roundness>=0
	end

	cx=MID_X + 0.5*MID_X*math.sin(.3*t)
	cy=MID_Y + 0.5*MID_Y*math.sin(.7*t)

	for x=0,WIDTH do
		dx=x-cx
		for y=0,HEIGHT do
			dy=y-cy

			angle=math.atan2(dy,dx) + t
			mag=(dx^2+dy^2)^.5
			offset=mag + roundness*math.cos(points*angle) - (RADIUS + RADIUS_PULSE*pulse)

			if offset<0 then
				color=1
			else
				color=2 + .8*(2+pulse)*math.log(offset+1)
			end

			pix(x, y, color)
		end
	end

	t=t+TIME_STEP
end
