ORG $6006   ; carefully chosen entry point, for printing asterisk

vccc2023_dapr:
    LD      HL, incdec      ; point to INC C / DEC C
    LD      D, C            ; initial position: C for Y, D for X

printAtDE:
    LD      A, 22   ; put AT code in A
    RST     16      ; select AT mode

    LD      B, 2    ; two iterations
    LD      A, C    ; put Y coord in A
    LD      E, 21   ; max value for Y comparison
loop:
    RST     16      ; AT Y (first iteration), AT X (second iteration)

    CP      A, E    ; load maximum value and test for it
    JR      NZ, tstmax
    INC     (HL)    ; self modify code
tstmax:
    AND     A, A    ; test minimum value (0)
    JR      NZ, tstmin
    DEC     (HL)    ; self modify code
tstmin:

    LD      A, D    ; put X coord in A
    LD      E, 18   ; max value for X comparison
    INC     HL      ; point to INC D / DEC D

    DJNZ    loop    ; perform next iteration

    DEC     HL
    DEC     HL       ; point to INC C / DEC C

    LD      A, C     ; do not print at first 3 rows
    SUB     A, 3
    JR      C, skipprint

    LD      A, L    ; asterisk ASCII code in L if ORG well chosen
    RST     16      ; select character to be printed and print

skipprint:

incdec:
                    ; perform X, Y increments / decrements
    DB      $0C     ; INC C / DEC C
    DB      $14     ; INC D / DEC D

    ; HALT  ; uncomment to slow draw for observing process

    JR printAtDE
