; ==========================================================================
; FAIRLY BAD SOLUTION FOR THE 2023 CHRISTMAS CONTEST 
; VERSION 2, THE BETTER-ER OPTIMIZATION OF SCREEN MEMORY.
;
; Kenneth Jennings
;
; Written for Atari 8-bit computers.
; Should work on any model.
; Should work on any memory size capable of running DOS to load an XEX.
;
; Assembly source intended for MADS assembler.
;
; The Atari 8-bit computers have more than one way of processing information
; to create a screen.  In addition to computing a shape with the 6502, the 
; Atari can "compute" (well, manipulate) a display using the ANTIC chip 
; which allows a program to optimize a display by re-use the same data at 
; different locations on the screen.
;
; This program exploits  Atari 8-bit computers' structured load format to 
; create a custom display list and screen data screen in memory.
;
; Screen memory is optimized from 380 bytes (20 x 19 lines) down to using
; only 63 bytes for screen memory.
;
; Screen data is optimized by re-using and overlapping screen data between
; lines where it makes the most sense.
; In this version "where it makes sense" is the two lines where stars are
; separated by five blanks.
;
; The exchange for reusing/redisplaying the same bytes of screen memory
; is adding more detail in the Display List.  The normal display list for 
; 19 lines of sequential screen memory would be about 27 bytes long.  This 
; program creates a Display List 50 bytes long.

; The program saves a byte in the Display List by removing one Display List 
; instruction for 8 blank scan lines from the top of the screen and so using 
; some of the overscan space.  This should display fine on any emulator and 
; real Atari.  (Really, if I wanted to make this viewable for only emulators
; I could remove all three instructions for blank lines in the oversan area.)
;
; The program executes only one 6502 instruction --  just a JMP do-nothing 
; loop to prevent returning to DOS.
;
; Total file size is 140 bytes.  
; 116 bytes loaded into Page 0:
; == 3  bytes of 6502 code (JMP to prevent returnning to DOS)
; == 63 bytes of screen data in memory
; == 50 bytes of display list in memory
; File also contains:
; == 6  bytes of miscellaneous data loaded in OS registers.
; == 18 bytes of load file format overhead.
;
; ==========================================================================
;
;     0000000000111111111
;     0123456789012345678
; 00 "   *     *     *   "
; 01 "  * *   * *   * *  "
; 02 " *   * *   * *   * "
; 03 "*     *     *     *" 
; 04 " *   * *   * *   * "
; 05 "  * *   * *   * *  "
; 06 "   *     *     *   "
; 07 "  * *   * *   * *  "
; 08 " *   * *   * *   * "
; 09 "*     *     *     *" 
; 10 " *   * *   * *   * "
; 11 "  * *   * *   * *  "
; 12 "   *     *     *   " 
; 13 "  * *   * *   * *  "
; 14 " *   * *   * *   * "
; 15 "*     *     *     *" 
; 16 " *   * *   * *   * "
; 17 "  * *   * *   * *  "
; 18 "   *     *     *   "
;
; ==========================================================================
;
; OS values for graphics 

SDMCTL       = $022F ; DMACTL
SDLSTL       = $0230 ; DLISTL

PLAYFIELD_WIDTH_NORMAL = %00000010 ; Normal, 160 color clocks screen width
ENABLE_DL_DMA          = %00100000 ; Enable running the display list

DL_BLANK_8 = $70       ; 8 Blank Scan lines
DL_LMS     = %01000000 ; Enable Reload Memory Scan address for this graphics line
DL_TEXT_6  = $06       ; 5 Color text, 20 Columns X 8 Scan lines, 20 bytes/line
DL_JUMP_VB = $41       ; Display List jump to address and start Vertical Blank

DOS_RUN_ADDR = $02E0 ; Execute here when file loading completes.


	ORG $0080 ; Uses the last half of page 0.  (116 bytes of data and 6502 code.)


; SCREEN RAM 
; 63 bytes defined to reduce a screen 20 chars x 19 lines (380 bytes)
; Spacing between stars is the same on the FOURSTAR and THREESTAR lines, so 
; most of the FOURSTAR data is borrowed from the THREESTAR line of data.
; The display list repeats displaying the same lines of data to build 
; the entire display.
; Data length on remaining lines fits the screen width (20 characters) and 
; are sequential to each other, so those mode lines in the display list would 
; not need the LMS option with the load addresses added.

FOURSTAR
	.sb "*  "                  ;  (3) Rest of line borrowed from THREESTAR
THREESTAR
	.sb "   *     *     *    " ; (20) 
SIXSTAR
	.sb "  * *   * *   * *   " ; (20) 
MORESTAR
	.sb " *   * *   * *   *  " ; (20)  20 + 20 + 20 + 3 == 63 bytes Total Screen RAM


; DISPLAY LIST
; Total DL size == 2 (blanks) + (3 * 13) + 6 + 3 (JVB) == 50 bytes

DISPLAY_LIST
	.byte DL_BLANK_8
	.byte DL_BLANK_8          ; (2)
; LINE 1                        
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word THREESTAR
; LINE 2
	.byte DL_TEXT_6   ; SIXSTAR (1)
; LINE 3
	.byte DL_TEXT_6  ; MORESTAR (1)
; LINE 4
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word FOURSTAR
; LINE 5
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word MORESTAR
; LINE 6
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word SIXSTAR
; LINE 7
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word THREESTAR
; LINE 8
	.byte DL_TEXT_6   ; SIXSTAR (1)
; LINE 9
	.byte DL_TEXT_6  ; MORESTAR (1)
; LINE 10
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word FOURSTAR
; LINE 11
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word MORESTAR
; LINE 12
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word SIXSTAR
; LINE 13
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word THREESTAR
; LINE 14
	.byte DL_TEXT_6   ; SIXSTAR (1)
; LINE 15
	.byte DL_TEXT_6  ; MORESTAR (1)
; LINE 16
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word FOURSTAR
; LINE 17
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word MORESTAR
; LINE 18
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word SIXSTAR
; LINE 19
	.byte DL_TEXT_6 | DL_LMS  ; (3)
	.word THREESTAR
; End of Display List
	.byte DL_JUMP_VB          ; (3)
	.word DISPLAY_LIST


;  The only 6502 code executed -- Just a jump to prevent going back to DOS

PROGRAM_START
	jmp PROGRAM_START


; Poke memory from disk to start things up...

	ORG SDMCTL
		.byte 0   ; turn off DMA in case the disk load does not finish in the same frame.

	ORG SDLSTL
		.word DISPLAY_LIST   ; Set Display List Pointer

	ORG SDMCTL
		.byte ENABLE_DL_DMA|PLAYFIELD_WIDTH_NORMAL ; Set Display DMA control to display screen

	ORG DOS_RUN_ADDR
		.word PROGRAM_START  ; Tell DOS where to begin the program execution.
		
;
	END
