#ifndef PASS_H
#define PASS_H

#include "demo.h"
#include "fbo.h"
#include "gl.h"
#include "shader.h"
#include "sync.h"
#include <stddef.h>

#define GET_VALUE(track_name)                                                  \
    sync_get_val(sync_get_track(rocket, track_name), rocket_row)

typedef struct {
    GLuint vao;
    GLuint vertex_shader;
} pass_renderer_t;

typedef struct {
    const pass_renderer_t *renderer;
    const fbo_t *draw_fb;
    const output_coord_t *viewport;
    const program_t *program;
    struct sync_device *rocket;
    double rocket_row;
    const GLuint *textures;
    const char **sampler_ufm_names;
    size_t n_textures;
} pass_render_parameters_t;

pass_renderer_t *pass_renderer_init(void);

void pass_renderer_deinit(pass_renderer_t *renderer);

void set_rocket_uniforms(const program_t *program, struct sync_device *rocket,
                         double rocket_row);

void pass_render(const pass_render_parameters_t *parameters);

#endif
