/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui;

import bk2010.gui.BK2010Display;
import bk2010.gui.MouseHandler;
import bk2010.gui.NoExclusiveModeException;
import bk2010.io.KeyMapper;
import bk2010.io.Mouse;
import bk2010.util.ResourceManager;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferStrategy;
import javax.swing.JFrame;

public class BK2010ExclusiveDisplay
extends BK2010Display {
    GraphicsDevice device;
    GraphicsConfiguration graphicsConfig;
    BKFullscreenWindow window;
    BufferStrategy bufferStrategy;

    public BK2010ExclusiveDisplay(KeyMapper keyMapper, Mouse mouse, String machineName) throws NoExclusiveModeException {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.device = env.getDefaultScreenDevice();
        if (!this.device.isFullScreenSupported()) {
            throw new NoExclusiveModeException("Fullscreen mode is not supported on " + this.device.getIDstring());
        }
        this.graphicsConfig = this.device.getDefaultConfiguration();
        this.keyMapper = keyMapper;
        this.mouse = mouse;
        MouseHandler mouseHandler = new MouseHandler(this, mouse);
        this.window = new BKFullscreenWindow(this.graphicsConfig, keyMapper, mouseHandler, this);
        this.window.setTitle(machineName);
        this.window.setIconImage(ResourceManager.getEmulatorIcon());
        this.window.setUndecorated(true);
        this.window.setResizable(false);
        this.window.setIgnoreRepaint(true);
        this.window.getRootPane().setDoubleBuffered(false);
        this.window.setDefaultCloseOperation(3);
        this.device.setFullScreenWindow(this.window);
        this.window.validate();
        Dimension dim = this.window.getSize();
        this.scrWidth = dim.width;
        this.scrHeight = dim.height;
        this.viewWidth = this.scrWidth;
        this.viewHeight = this.scrHeight;
        int aspX = this.viewWidth * 3;
        int aspY = this.viewHeight * 4;
        if (aspX > aspY) {
            this.viewWidth = this.viewHeight * 4 / 3;
            this.viewX = (this.scrWidth - this.viewWidth) / 2;
        } else if (aspX < aspY) {
            this.viewHeight = this.viewWidth * 3 / 4;
            this.viewY = (this.scrHeight - this.viewHeight) / 2;
        }
        this.window.createBufferStrategy(2);
        this.bufferStrategy = this.window.getBufferStrategy();
        this.repaint();
    }

    @Override
    public Point getLocationOnScreen() {
        return new Point(this.viewX, this.viewY);
    }

    @Override
    public int getWidth() {
        return this.viewWidth;
    }

    @Override
    public int getHeight() {
        return this.viewHeight;
    }

    public String getDeviceName() {
        return this.device.getIDstring();
    }

    @Override
    public boolean isFullScreen() {
        return true;
    }

    @Override
    public void notifyMouseGrabToggle(boolean enable) {
    }

    @Override
    public void requestFocusInWindow() {
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void repaint() {
        if (this.window.isFocused()) {
            Graphics gfx = this.bufferStrategy.getDrawGraphics();
            this.paintMe(gfx);
            this.bufferStrategy.show();
            gfx.dispose();
        }
    }

    static class BKFullscreenWindow
    extends JFrame {
        public BKFullscreenWindow(GraphicsConfiguration gc, final KeyMapper keyMapper, final MouseHandler mouseHandler, BK2010ExclusiveDisplay display) {
            super(gc);
            this.setCursor(emptyCursor);
            this.setFocusable(true);
            this.setFocusTraversalKeysEnabled(false);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    keyMapper.keyHit(e);
                    e.consume();
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    keyMapper.keyRelease(e);
                    e.consume();
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    e.consume();
                }
            });
            this.addMouseListener(mouseHandler);
            this.addMouseMotionListener(mouseHandler);
            this.addMouseWheelListener(mouseHandler);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    mouseHandler.grabMouse(false);
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        }
    }
}

