/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.dataGrid;

import java.util.Arrays;

public class DataGridFormat {
    protected boolean isHeaderPresent;
    protected int rows;
    protected int columns;
    protected int[] columnWidths;
    protected String[] columnNames;

    public DataGridFormat(int rows, int columns, int[] columnWidths, String[] columnNames) {
        this.isHeaderPresent = true;
        this.rows = rows;
        this.columns = columns;
        this.columnWidths = columnWidths;
        this.columnNames = Arrays.copyOf(columnNames, columns);
        this.fillColumnNames("");
    }

    public DataGridFormat(int rows, int columns, int[] columnWidths) {
        this.rows = rows;
        this.columns = columns;
        this.columnWidths = columnWidths;
        this.fillColumnNames("");
    }

    protected void fillColumnNames(String filler) {
        int i = 0;
        while (i < this.columns) {
            if (this.columnNames[i] == null) {
                this.columnNames[i] = filler;
            }
            ++i;
        }
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int[] getColumnWidths() {
        return this.columnWidths;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setColumnWidths(int[] columnWidths) {
        this.columnWidths = columnWidths;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public boolean gotHeader() {
        return this.isHeaderPresent;
    }
}

