/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger.memscape;

import bk2010.hardware.bus.QBusObserver;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class MemScapeDisplay
extends JComponent
implements QBusObserver {
    private static final long serialVersionUID = 1L;
    public static final int ADDRESS_RANGE = 65536;
    byte[] accessMap = new byte[196608];
    final int mapWidth;
    final int mapHeight = (65536 + this.mapWidth - 1) / this.mapWidth;
    transient BufferedImage cachedMap;
    boolean updated;

    public MemScapeDisplay() {
        this.mapWidth = 256;
        Dimension prefSize = new Dimension(this.mapWidth, this.mapHeight);
        this.setPreferredSize(prefSize);
        this.cachedMap = new BufferedImage(this.mapWidth, this.mapHeight, 5);
    }

    @Override
    public void memoryAccessNotification(int addr, int type, int data) {
        if (addr < 0 || addr >= 65536 || type < 0 || type > 3) {
            return;
        }
        if (type == 3) {
            this.accessMap[addr * 3 + 0] = -1;
        } else {
            this.accessMap[addr * 3 + type] = -1;
            this.accessMap[(addr ^ 1) * 3 + type] = -1;
        }
        this.updated = true;
    }

    public void newFrame() {
        int i = 0;
        while (i < this.accessMap.length) {
            int b = this.accessMap[i] & 0xFF;
            if (b != 0) {
                this.accessMap[i] = b < 4 ? (byte)0 : (byte)(b - 4);
            }
            ++i;
        }
        this.cachedMap.getRaster().setDataElements(0, 0, this.mapWidth, this.mapHeight, this.accessMap);
        this.updated = false;
        this.repaint(20L);
    }

    @Override
    public void paint(Graphics g) {
        if (this.updated) {
            this.cachedMap.getRaster().setDataElements(0, 0, this.mapWidth, this.mapHeight, this.accessMap);
            this.updated = false;
        }
        g.drawImage(this.cachedMap, 0, 0, null);
    }
}

