/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger.ui15;

import bk2010.gui.helpers.Tools;
import bk2010.hardware.bus.QBusProxy;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class MemoryView
extends JComponent
implements Scrollable {
    private static final long serialVersionUID = 1173621929133375781L;
    static final int TOTAL_MEMWORDS = 32768;
    QBusProxy memory;
    int wordsPerRow = 8;
    int preferredColumns = 8 + this.wordsPerRow * 9;
    int preferredRows = 12;
    int preferredWidth;
    Dimension preferredSize;
    Dimension totalSize;
    int pad = 2;
    int fontHeight;
    int rowHeight;
    int fontBaseline;
    int totalHeight;
    int selectedRow = -1;
    int selectedColumn = 0;

    public MemoryView(QBusProxy memory) {
        this.memory = memory;
        this.setFont(Tools.monoFont);
        this.fontHeight = Tools.fontHeight;
        this.preferredWidth = Tools.fontWidth * this.preferredColumns + this.pad + this.pad;
        this.rowHeight = this.fontHeight + this.pad + this.pad;
        this.totalHeight = this.rowHeight * 32768 / this.wordsPerRow;
        this.fontBaseline = Tools.fontBase;
        int prefHeight = this.rowHeight * this.preferredRows;
        this.preferredSize = new Dimension(this.preferredWidth, prefHeight);
        this.totalSize = new Dimension(this.preferredWidth, this.totalHeight);
        this.setMinimumSize(new Dimension(this.preferredWidth, this.rowHeight));
        this.setMaximumSize(this.totalSize);
        this.setPreferredSize(this.totalSize);
    }

    public void ensureVisible(int addr) {
        addr &= 0xFFFE;
        Container parent = this.getParent();
        if (!(parent instanceof JViewport)) {
            return;
        }
        int targetRow = addr / (2 * this.wordsPerRow);
        this.scrollRectToVisible(new Rectangle(0, this.rowHeight * targetRow, this.preferredWidth, this.rowHeight * this.preferredRows / 2));
    }

    public void setSelectedAddr(int addr) {
        this.selectedRow = (addr & 0xFFFF) / (2 * this.wordsPerRow);
        this.selectedColumn = (addr & 0xFFFF) % (2 * this.wordsPerRow);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredSize;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation != 1) {
            return 0;
        }
        return this.rowHeight;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation != 1) {
            return 0;
        }
        return this.rowHeight * 10;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle vis = this.getVisibleRect();
        int firstLine = Math.max(vis.y / this.rowHeight, 0);
        int lastLine = Math.min((vis.y + vis.height + this.rowHeight - 1) / this.rowHeight, Short.MAX_VALUE);
        if (lastLine < firstLine) {
            return;
        }
        int[] words = new int[this.wordsPerRow];
        int i = firstLine;
        while (i <= lastLine) {
            int word;
            int y = i * this.rowHeight + this.pad;
            int addr = i * this.wordsPerRow * 2;
            StringBuffer line = new StringBuffer(this.preferredColumns);
            line.append(String.format(Locale.ROOT, "%06o: ", addr));
            if (i == this.selectedRow) {
                Color oldColor = g2.getColor();
                g2.setColor(Color.GREEN);
                g2.fillRect(0, y - this.pad, this.getWidth(), this.rowHeight);
                g2.setColor(oldColor);
            }
            int j = 0;
            while (j < this.wordsPerRow) {
                int word2 = this.memory.peekWord(addr + j * 2);
                if ((word2 & 0xFFFF0000) != 0) {
                    words[j] = -1;
                    line.append("\u2022\u2022");
                } else {
                    words[j] = word2;
                    line.append("\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u25a0\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u044e\u0430\u0431\u0446\u0434\u0435\u0444\u0433\u0445\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u044f\u0440\u0441\u0442\u0443\u0436\u0432\u044c\u044b\u0437\u0448\u044d\u0449\u0447\u044a\u042e\u0410\u0411\u0426\u0414\u0415\u0424\u0413\u0425\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u042f\u0420\u0421\u0422\u0423\u0416\u0412\u042c\u042b\u0428\u042d\u0429\u0427\u042a?".charAt(word2 & 0xFF));
                    line.append("\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u25a0\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u044e\u0430\u0431\u0446\u0434\u0435\u0444\u0433\u0445\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u044f\u0440\u0441\u0442\u0443\u0436\u0432\u044c\u044b\u0437\u0448\u044d\u0449\u0447\u044a\u042e\u0410\u0411\u0426\u0414\u0415\u0424\u0413\u0425\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u042f\u0420\u0421\u0422\u0423\u0416\u0412\u042c\u042b\u0428\u042d\u0429\u0427\u042a?".charAt(word2 >> 8 & 0xFF));
                }
                ++j;
            }
            int[] nArray = words;
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                word = nArray[n2];
                if (word >= 0) {
                    line.append(String.format(" %06o", word));
                } else {
                    line.append(" \u2022\u2022\u2022\u2022\u2022\u2022");
                }
                ++n2;
            }
            line.append(" --");
            nArray = words;
            n = words.length;
            n2 = 0;
            while (n2 < n) {
                word = nArray[n2];
                if (word >= 0) {
                    line.append(String.format(" %03o %03o", word & 0xFF, word >> 8 & 0xFF));
                } else {
                    line.append(" \u2022\u2022\u2022 \u2022\u2022\u2022");
                }
                ++n2;
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawString(line.toString(), 0, y + this.fontBaseline);
            ++i;
        }
    }
}

