/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.dialogs;

import bk2010.gui.dialogs.ConfigurationDialog;
import bk2010.gui.dialogs.SelectFilePanel;
import bk2010.hardware.bus.QBusProxy;
import bk2010.io.FakeTape;
import bk2010.preferences.PathStrings;
import bk2010.util.ResourceManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class BinOpenDialog
extends ConfigurationDialog {
    SelectFilePanel filePanel;

    public BinOpenDialog(final QBusProxy memory) {
        super("Open .bin file");
        this.setIconImage(ResourceManager.getEmulatorIcon());
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BinOpenDialog.this.setVisible(false);
                File file = BinOpenDialog.this.filePanel.getFile();
                if (file != null) {
                    try {
                        FakeTape.loadFile(memory, (short)0, file.getCanonicalPath());
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(null, "Could not read the file!", "Error", 0);
                    }
                }
            }
        };
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BinOpenDialog.this.setVisible(false);
            }
        };
        this.filePanel = new SelectFilePanel(PathStrings.binFilesPath, ".bin", "BK binary dump file");
        this.add((Component)this.filePanel, "Center");
        Box okCancelPanel = Box.createHorizontalBox();
        okCancelPanel.add(Box.createHorizontalGlue());
        JButton jbOk = new JButton("OK");
        jbOk.addActionListener(okAction);
        okCancelPanel.add(jbOk);
        JButton jbCancel = new JButton("Cancel");
        jbCancel.addActionListener(cancelAction);
        okCancelPanel.add(jbCancel);
        okCancelPanel.add(Box.createHorizontalGlue());
        InputMap imap = okCancelPanel.getInputMap(2);
        imap.put(KeyStroke.getKeyStroke(10, 0), "OK");
        imap.put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        ActionMap amap = okCancelPanel.getActionMap();
        amap.put("OK", okAction);
        amap.put("Cancel", cancelAction);
        this.add((Component)okCancelPanel, "South");
        this.pack();
        this.center();
        jbOk.requestFocusInWindow();
    }
}

