/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.bus.registers;

import bk2010.hardware.bus.QBusSimpleSlave;

public final class FocalIRPS
extends QBusSimpleSlave {
    private static final int IRPSBase = 65392;
    private static final int IRPSRxStatus = 65392;
    private static final int IRPSRxData = 65394;
    private static final int IRPSTxStatus = 65396;
    private static final int IRPSTxData = 65398;
    private static final int IRPSvector = 48;
    protected short txStatus = (short)128;
    protected short txData = 0;
    protected short rxStatus = 0;
    protected short rxData = 0;

    @Override
    public int getBaseAddress() {
        return 65392;
    }

    @Override
    public int getNumWords() {
        return 4;
    }

    @Override
    public boolean gotInterrupt() {
        return (this.txStatus & 0xC0) == 192 || (this.rxStatus & 0xC0) == 192;
    }

    @Override
    public byte interruptVector() {
        return (byte)((this.rxStatus & 0x80) != 0 ? 48 : 52);
    }

    @Override
    public int peekWord(int addr) {
        switch (addr & 0xFFFFFFFE) {
            case 65398: {
                return 48;
            }
            case 65396: {
                return this.txStatus & 0xFFFF;
            }
            case 65394: {
                this.rxStatus = (short)(this.rxStatus & 0xFFFFFF37);
                return this.rxData & 0xFFFF;
            }
            case 65392: {
                return this.rxStatus & 0xFFFF;
            }
        }
        return -1;
    }

    @Override
    public boolean writeByteAsWord(int addr, short data) {
        if ((addr & 1) != 0) {
            return true;
        }
        switch (addr & 0xFFFFFFFE) {
            case 65398: {
                this.txData = (short)(data & 0xFF);
                this.txStatus = (short)(this.txStatus & 0xFFFFFF37);
                return true;
            }
            case 65396: {
                this.txStatus = (short)(this.txStatus & 0xFFFFFFBF | data & 0x40);
                return true;
            }
            case 65394: {
                return true;
            }
            case 65392: {
                this.rxStatus = (short)(this.rxStatus & 0xFFFFFFBF | data & 0x40);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean writeWord(int addr, short data) {
        return this.writeByteAsWord(addr, data);
    }

    @Override
    public void reset() {
        this.txStatus = (short)128;
        this.txData = 0;
        this.rxStatus = 0;
        this.rxData = 0;
    }

    public int pollTx() {
        if ((this.txStatus & 0x80) != 0) {
            return -1;
        }
        this.txStatus = (short)(this.txStatus | 0x80);
        return this.txData & 0xFF;
    }
}

