/*
 * Decompiled with CFR 0.152.
 */
package bk2010.io;

import bk2010.util.Log;

public final class Mouse {
    public static final int X_PLUS = 2;
    public static final int X_MINUS = 8;
    public static final int Y_PLUS = 4;
    public static final int Y_MINUS = 1;
    public static final int LEFT_BUTTON = 32;
    public static final int RIGHT_BUTTON = 64;
    public static final int WHEEL_UP = 128;
    public static final int WHEEL_DOWN = 16;
    static final int CLAMP_VALUE = 32;
    float sens = 0.2f;
    volatile float dx;
    volatile float dy;
    volatile int buttons;
    volatile int wheel;
    volatile int bits;
    private final Object updateMutex = new Object();

    private void updateBits() {
        int newBits = 0;
        if ((this.buttons & 1) != 0) {
            newBits |= 0x20;
        }
        if ((this.buttons & 4) != 0) {
            newBits |= 0x40;
        }
        if (this.dx <= -1.0f) {
            newBits |= 8;
        } else if (this.dx >= 1.0f) {
            newBits |= 2;
        }
        if (this.dy <= -1.0f) {
            newBits |= 1;
        } else if (this.dy >= 1.0f) {
            newBits |= 4;
        }
        if (this.wheel < 0) {
            newBits |= 0x80;
        } else if (this.wheel > 0) {
            newBits |= 0x10;
        }
        this.bits = newBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMove(int moveX, int moveY) {
        Object object = this.updateMutex;
        synchronized (object) {
            Log.verbose("Mouse delta %d, %d\n", moveX, moveY);
            this.dx = Math.max(-32.0f, Math.min(this.dx + (float)moveX * this.sens, 32.0f));
            this.dy = Math.max(-32.0f, Math.min(this.dy + (float)moveY * this.sens, 32.0f));
            this.updateBits();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateButtons(int newButtons) {
        Object object = this.updateMutex;
        synchronized (object) {
            this.buttons = newButtons;
            this.updateBits();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWheel(int delta) {
        Object object = this.updateMutex;
        synchronized (object) {
            this.wheel = Math.max(-32, Math.min(this.wheel + delta, 32));
            this.updateBits();
        }
    }

    public int getIO() {
        return this.bits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeMove() {
        Object object = this.updateMutex;
        synchronized (object) {
            if (this.dx >= 1.0f) {
                this.dx -= 1.0f;
            } else if (this.dx <= -1.0f) {
                this.dx += 1.0f;
            }
            if (this.dy >= 1.0f) {
                this.dy -= 1.0f;
            } else if (this.dy <= -1.0f) {
                this.dy += 1.0f;
            }
            this.wheel = 0;
            this.updateBits();
        }
    }
}

