/*
 * Decompiled with CFR 0.152.
 */
package bk2010.preferences.types;

import bk2010.preferences.storage.ConfigFile;
import bk2010.preferences.storage.Setting;
import bk2010.util.Log;

public class OnOff
implements Cloneable {
    public final String name;
    private boolean state;

    public OnOff(String name) {
        this.name = name;
    }

    public OnOff(String name, boolean state) {
        this.name = name;
        this.state = state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public boolean getState() {
        return this.state;
    }

    public void saveTo(ConfigFile cf, String prefix) {
        String fullName = String.valueOf(prefix) + this.name;
        Setting s = cf.getSetting(fullName);
        s = s == null ? new Setting(fullName, this.state ? "yes" : "no", "") : new Setting(s.name, this.state ? "yes" : "no", s.comments);
        cf.setSetting(s);
    }

    public void readFrom(ConfigFile cf, String prefix) {
        String fullName = String.valueOf(prefix) + this.name;
        Setting s = cf.getSetting(fullName);
        if (s == null || s.value.isEmpty()) {
            return;
        }
        String value = s.value.toLowerCase();
        if (value.equals("yes") || value.equals("on") || value.equals("true") || value.equals("1")) {
            this.setState(true);
        } else if (value.equals("no") || value.equals("off") || value.equals("false") || value.equals("0")) {
            this.setState(false);
        } else {
            Log.error("Unknown value " + s.value + " for configuration setting " + fullName);
        }
    }

    public OnOff clone() {
        return new OnOff(this.name, this.state);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.state ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OnOff other = (OnOff)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.state == other.state;
    }
}

