/*
 * Decompiled with CFR 0.152.
 */
package bk2010.sound;

import bk2010.hardware.TimeSource;
import bk2010.sound.SoundProvider;
import bk2010.sound.StreamOutput;
import bk2010.util.Log;
import java.util.Arrays;

public final class SoundRenderer {
    private static final int FPBASE = 4096;
    private final StreamOutput so;
    private final TimeSource ts;
    private final int xCPS;
    private final float recCps;
    private SoundProvider synthA;
    private SoundProvider synthB;
    private static final int BUF_SIZE = 32768;
    private static final int BUF_MASK = Short.MAX_VALUE;
    private byte[] buf = new byte[32768];
    private int head = 0;
    private int tail = 0;
    private long lastUpdate;
    private int xSubSampleOffset = 0;
    private static final int SND_ON = 16;
    private static final int SND_OFF = -16;
    private static final int SND_REST = 0;
    private int xAcc = 0;
    private int val = -16;
    private int covoxVal = 0;
    private int bitVal = -16;
    private int feedback = 0;
    private boolean filterOn;

    public SoundRenderer(StreamOutput output, TimeSource timeSource, float cyclesPerSample) {
        this.so = output;
        this.ts = timeSource;
        this.xCPS = Math.round(cyclesPerSample * 4096.0f);
        this.recCps = 1.0f / (float)this.xCPS;
        Arrays.fill(this.buf, (byte)0);
        this.lastUpdate = this.ts.getCycles();
    }

    public void setSynths(SoundProvider synthA, SoundProvider synthB) {
        this.synthA = synthA;
        this.synthB = synthB;
    }

    public void setFilterEnable(boolean en) {
        this.filterOn = en;
    }

    public void catchUp() {
        int xRem;
        long cycles = this.ts.getCycles();
        int xStep = (int)(cycles - this.lastUpdate) * 4096;
        if (xStep < (xRem = this.xCPS - this.xSubSampleOffset)) {
            this.xAcc += this.val * xStep;
            this.xSubSampleOffset += xStep;
            this.lastUpdate = cycles;
            return;
        }
        this.xAcc += this.val * xRem;
        int sum = (int)((float)this.xAcc * this.recCps * 256.0f);
        if (this.synthA != null) {
            sum += this.synthA.nextSample();
        }
        if (this.synthB != null) {
            sum += this.synthB.nextSample();
        }
        if (this.filterOn) {
            sum = this.feedback = this.feedback / 2 + this.feedback / 4 + sum / 4;
        }
        this.buf[this.head] = (byte)(sum & 0xFF);
        this.buf[this.head + 1] = (byte)((sum & 0xFF00) >> 8);
        this.head = this.head + 2 & Short.MAX_VALUE;
        xStep -= xRem;
        this.xSubSampleOffset = 0;
        this.xAcc = 0;
        while (xStep >= this.xCPS) {
            sum = (int)((float)(this.val * this.xCPS) * this.recCps * 256.0f);
            if (this.synthA != null) {
                sum += this.synthA.nextSample();
            }
            if (this.synthB != null) {
                sum += this.synthB.nextSample();
            }
            if (this.filterOn) {
                sum = this.feedback = this.feedback / 2 + this.feedback / 4 + sum / 4;
            }
            this.buf[this.head] = (byte)(sum & 0xFF);
            this.buf[this.head + 1] = (byte)((sum & 0xFF00) >> 8);
            this.head = this.head + 2 & Short.MAX_VALUE;
            xStep -= this.xCPS;
        }
        this.xAcc = this.val * xStep;
        this.xSubSampleOffset = xStep;
        this.lastUpdate = cycles;
    }

    public void updateBit(int maskedVal) {
        this.catchUp();
        this.bitVal = maskedVal == 0 ? -16 : 16;
        this.val = this.bitVal + this.covoxVal + 0;
    }

    public void updateCovox(int value) {
        this.catchUp();
        this.covoxVal = ((value & 0xFF) - 128) / 4;
        this.val = this.bitVal + this.covoxVal + 0;
    }

    public void push() {
        this.catchUp();
        if (this.head == this.tail) {
            return;
        }
        int count = this.head - this.tail & Short.MAX_VALUE;
        if (count > 1924 || count <= 0) {
            Log.verbose("#" + count + "#");
        }
        if (this.head < this.tail) {
            this.so.pushSamples(this.buf, this.tail, 32768 - this.tail);
            if (this.head > 0) {
                this.so.pushSamples(this.buf, 0, this.head);
            }
        } else {
            this.so.pushSamples(this.buf, this.tail, this.head - this.tail);
        }
        this.tail = this.head;
    }
}

