/*
 * Decompiled with CFR 0.152.
 */
package bk2010.util;

import bk2010.util.BootLog;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.Instant;
import java.util.Locale;

public final class Log {
    private static boolean disabled = false;
    private static boolean toConsole = false;
    private static boolean beVerbose = false;
    private static FileWriter fw;

    private Log() {
    }

    private static void closeLog() {
        FileWriter ffw = fw;
        fw = null;
        if (ffw != null) {
            try {
                ffw.close();
            }
            catch (IOException e) {
                BootLog.l("Unable to write to the log file (%s), closing it;", e.getMessage());
            }
        }
    }

    private static void append(String line) {
        if (disabled) {
            return;
        }
        if (toConsole) {
            System.out.println(line);
        }
        if (fw != null) {
            try {
                fw.write(line);
                fw.flush();
            }
            catch (IOException e) {
                Log.closeLog();
                BootLog.l("Failed to write to the log file, closing it.");
            }
        }
    }

    private static void append(char c) {
        Log.append(Character.toString(c));
    }

    public static void l(String line) {
        if (disabled) {
            return;
        }
        Log.append(line);
    }

    public static void l(String format, Object ... args) {
        if (disabled) {
            return;
        }
        Log.append(String.format(Locale.ROOT, format, args));
    }

    public static void error(String line) {
        if (disabled) {
            return;
        }
        Log.append("ERROR: " + line);
    }

    public static void error(String format, Object ... args) {
        if (disabled) {
            return;
        }
        Log.append("ERROR: " + String.format(Locale.ROOT, format, args));
    }

    public static void warning(String line) {
        if (disabled) {
            return;
        }
        Log.append("WARNING: " + line);
    }

    public static void warning(String format, Object ... args) {
        if (disabled) {
            return;
        }
        Log.append("WARNING: " + String.format(Locale.ROOT, format, args));
    }

    public static void verbose(char c) {
        if (disabled) {
            return;
        }
        if (!beVerbose) {
            return;
        }
        Log.append(c);
    }

    public static void verbose(String line) {
        if (disabled) {
            return;
        }
        if (!beVerbose) {
            return;
        }
        Log.append(line);
    }

    public static void verbose(String format, Object ... args) {
        if (disabled) {
            return;
        }
        if (!beVerbose) {
            return;
        }
        Log.append(String.format(null, format, args));
    }

    public static boolean setLogFile(File f) {
        Log.closeLog();
        if (disabled) {
            return false;
        }
        if (f == null) {
            return true;
        }
        try {
            fw = new FileWriter(f, true);
        }
        catch (IOException e) {
            fw = null;
            try {
                BootLog.l("Unable to use log file %s (%s).", f.getCanonicalPath(), e.getMessage());
            }
            catch (IOException e1) {
                BootLog.l("Unable to use log file %s (%s); also was unable to interpret the log file path (%s).", f.getPath(), e.getMessage(), e1.getMessage());
            }
            return false;
        }
        Log.append("Logging to file started at " + Instant.now().toString());
        return true;
    }

    public static void enableConsole(boolean verbose) {
        toConsole = true;
        beVerbose |= verbose;
    }

    public static void disable() {
        disabled = true;
        Log.closeLog();
    }
}

