#!/bin/env bash

distrodir="distro"
if [ "$#" == "1" ]
then
    if [ -f "$1" ]
    then
        filename=$(echo $1 | sed 's/\.asm//g')

        bin_filename="${filename}.bin"
        sym_filename="${filename}.sym"
        lst_filename="${filename}.lst"

        echo Assemblying!
        if /c/dasm220/dasm "$1" -I"C:\\dasm220\\machines\\atari2600\\" -o"${bin_filename}" -s"${sym_filename}" -l"${lst_filename}"
        then 
            echo Keeping whole copy at ${distrodir}/...
            cp "${filename}.bin" "${distrodir}/wh_${filename}.bin"

            echo ... trimming base address...
            python trim.py "${bin_filename}"
            echo ... keeping trimmed copy at ${distrodir}/...
            cp "${filename}.bin" "${distrodir}/"
        else
            echo Error while trimming...
        fi
    else
        echo \"$1\" not a valid file...
    fi

else
    echo Wrong parameter number. 
    exit
fi
