; characters 0..15 set to GTIA luminances in font

open_mode	= $ef9c		; A=mode

SAVMSC		= $58		; word
screen_mem	= SAVMSC	; alias

RTCLOCK  equ $0012;
WSYNC   equ $D40A
RANDOM  equ $D20A
VCOUNT  equ $D40B

GPRIOR		= $26f		; GTIA modes: $40=9,$80=10,$c0=11
CHBAS		= $2f4		; character base
GRAFP0   	= $d00d
SIZEP0      	= $d008
HPOSP0      	= $d000
SDMCTL	= $022f
CPLAYER0 equ $D012 ; kolor gracza 0

Timer equ 552
VTimr equ 538
VVBLKD  equ $0224
XITVBV  equ $e462

tmp	= $80 ; <- taka zmienna na ZP w ktrej jest 0 na pocztku
cm  = $81
col   equ 80
my_font		= $4000
sin_t	= $2000 ; <- adres tabicy sinusa (tablica zajmuje 1 stron pamici)

	org $82
start		
	lda #$50
	sta GPRIOR
           
    lda #%00100010;
	sta SDMCTL;    lda #16; one line

	ldy #$6f
	sty SIZEP0
	sty SIZEP0+1
;	sty HPOSP0

	lda #>my_font
	sta CHBAS
			
; copy data to font
; 17 bytes

			ldy #0
			sty col
			tya
fill_all
			ldx #7
fill_char
			sta my_font,y
			iny
			dex
			bpl fill_char
			clc
			adc #$11
			bcc fill_all

		ldy #$7f
		sty SIZEP0
;sine
;procka zajmuje 25b na ZP albo 27b poza ZP 
;amplituda cosinusa: $00-$20
	ldx #0
;    stx cm
	ldy #0
loop
	txa
	asl @
	adc tmp
	sta tmp
	bvc __1
	inc __1+1
__1	lda #$70 ;<- warto centrujca (mona zmienia aby przesun rodek amplitudy)
a_sin_t equ *+1
	sta sin_t,x
	dey
.IF	a_sin_t<255
	sta (a_sin_t),y
.ELSE
	sta sin_t,y
.ENDIF
	inx
	bpl loop
			
    ldx #3
;    ldx #23; 23 linie
;fill screen
fill_screen
    ldy #$ff
;    ldy #39; 40 znakw
fill_block
	tya
	and #15
ekr equ *+1
	sta $bc40,y; screen mem
	dey
	bne fill_block
;    adw ekr #40; dodaj 40 do adresu
    adw ekr #$ff; dodaj 40 do adresu
    dex
	bpl fill_screen 
; roll font

;    lda #20
;    ldx <roll
;    ldy >roll
;    stx Timer
;    sty Timer+1
;    sta Vtimr

vco ;jmp vco
    lda vcount
    bne vco
	tay

    inc col
skip	
    ldx col

next_char

    lda font_offsets,y
    sta font_lo+1
	
colorloop	
    dex
font_lo
	lda $e100
    sta wsync
	sta GRAFP0
    sta GRAFP0+1
	txa
    sta GRAFP0+2
    sta GRAFP0+3
    
	and #%11110000
    sta wsync
	sta $d01a
    lda vcount
;	adc 20
    adc rtclock+2
	tax
	lda sin_t,x
    sta $d01f;consol;
    sta CPLAYER0
    sta cplayer0+1
;    adc #48
    adc RTCLOCK+2
	sta HPOSP0
    sta hposp0+2
    EOR #$FF
    sta HPOSP0+1
    sta hposp0+3

	inc font_lo+1
	lda font_lo+1
	and #7
	bne font_lo

	iny
	cpy #21
	bne next_char
;	bne colorloop
	beq vco

; vtimer

vbrout
    ldy #0
fnt
	lda my_font,y
	clc
adcsbc 
	adc #$01
;    ror @
	sta my_font,y
	iny
	cpy #(16*8)
	bne fnt
    
	lda rtclock+2
	bne quit

    lda adcsbc
	eor #$80; adc/sbc
	sta adcsbc
quit
	jmp xitvbv

font_offsets
; spacje
		dta $f6,$f6,$f6,$f6,$f6,$f6
;heart;last
    dta $f0,$f6,$60,$08,$98,$a0,$f6,$f6,$f6
;party
    dta $80,$08,$90,$a0,$c8,$f6    
	
    org vvblkd
	.word .adr(vbrout)

    run(start)