;
; Intro stub (c)MX^Addict
;
BITS 32

;
; Resolution
;
WIDTH  equ 1600
HEIGHT equ  900

;
; Fullscreen ?
;
; %define FULLSCREEN

;
; Music
;
%define SAMPLE_RATE   44100
%define TOTAL_SAMPLES (WIDTH*HEIGHT)
%define TOTAL_LOOPS   2	; Only 1 or 2 !

;
; Misc defines
;
%include "misc.inc"

;
; Data
;

;
; Screen mode settings (only in fullscreen)
; DEVMODE = 
; { 
; 	{0}, 0, 0, sizeof(DEVMODE), 0, DM_PELSWIDTH|DM_PELSHEIGHT, {0}, 0, 0, 0, 0, 0, {0}, 0, 0, XRES, YRES, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; };
;
%ifdef FULLSCREEN
section _devmode data align=1
devmode:
	times 9 dd 0
	db 0x9c, 0, 0, 0
	db 0, 0, 0x1c, 0
	times 15 dd 0
	dd 020H, WIDTH, HEIGHT
	times 10 dd 0
%endif

;
; Pixel format descriptor
; PIXELFORMATDESCRIPTOR = 
; {
;     sizeof(PIXELFORMATDESCRIPTOR), 1, PFD_DRAW_TO_WINDOW|PFD_SUPPORT_OPENGL|PFD_DOUBLEBUFFER, PFD_TYPE_RGBA, 32, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 32, 0, 0, PFD_MAIN_PLANE, 0, 0, 0, 0
; };
;
section _pfd data align=1
pfd:
	dw  028H
	dw	01H
	dd	025H
	db	00H
	db	020H
	db	00H
	db	00H
	db	00H
	db	00H
	db	00H
	db	00H
	db	08H
	db	00H
	db	00H
	db	00H
	db	00H
	db	00H
	db	00H
	db	020H
	db	00H
	db	00H
	db	00H
	db	00H
	dd	00H
	dd	00H
	dd	00H

;
; Wave format
;
section _wavefmt data align=1
wavefmt:
	dw 3 					; wFormatTag = WAVE_FORMAT_IEEE_FLOAT
	dw 1 					; nChannels
	dd SAMPLE_RATE 			; nSamplesPerSec
	dd SAMPLE_RATE * 4 * 1	; nAvgBytesPerSec (SAMPLE_RATE * sizeof(SAMPLE) * nChannels)
    dw 4 * 1 				; nBlockAlign (sizeof(SAMPLE) * nChannels)
    dw 32	 				; wBitsPerSample
    dw 0 					; cbSize

;
; Wave header
;
section _wavehdr data align=1
wavehdr:
	dd MusicBuffer						   ; lpData
	dd TOTAL_SAMPLES * 4 * 1 * TOTAL_LOOPS ; dwBufferLength (TOTAL_SAMPLES * sizeof(SAMPLE) * nChannels)
	times 2 dd 0 						   ; unused stuff
	dd 2 								   ; dwFlags WHDR_PREPARED  =  0x00000002
	dd 0
	times 4 dd 0 						   ; unused stuff
	wavehdr_size EQU ($ - wavehdr)

;
; BSS sections
;
section _mmtime bss align=1
mmtime: resb 12

section _waveout bss align=1
waveout: resd 8

section _sndbuf bss align=1
MusicBuffer: resd TOTAL_SAMPLES * 1 * TOTAL_LOOPS

;
; Shaders
;
section _shader data align=1
%include "fragment.inc"

section _shdrptr data align=1
src_main:
	dd _fragment_frag0
src_music:
	dd _fragment_frag1
		
;
; Code, Main entry
;
section _text text align=1
_start:
	%define ZERO 0
		
	;
	; Switch to fullscreen & create window
	;
%ifdef FULLSCREEN
	FNCALL ChangeDisplaySettingsA, devmode, 4
	FNCALL ShowCursor, ZERO
	FNCALL CreateWindowExA, ZERO, 0x0000c018, ZERO, 0x91000000, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO
%else
	FNCALL CreateWindowExA, ZERO, 0x0000c018, ZERO, 0x90000000, ZERO, ZERO, WIDTH, HEIGHT, ZERO, ZERO, ZERO, ZERO
%endif

	;
	; Initialize OpenGL
	;
	FNCALL GetDC, eax
	mov esi, eax ; esi = HDC
	FNCALL ChoosePixelFormat, esi, pfd
	FNCALL SetPixelFormat, esi, eax, pfd
	FNCALL wglCreateContext, esi
	FNCALL wglMakeCurrent, esi, eax

	;
	; Create shaders & generate music
	;
	FNCALL wglGetProcAddress, glCreateShaderProgramv
	push eax ; glCreateShaderProgramv on stack
	FNCALL eax, GL_FRAGMENT_SHADER, 1, src_music
	push eax ; music_shader
	FNCALL wglGetProcAddress, glUseProgram
	mov edi, eax ; edi - useProgram
	call eax
	FNCALL glRects, byte -1, byte -1, byte 1, byte 1
	FNCALL glReadPixels, 0, 0, WIDTH, HEIGHT, GL_RGBA, GL_UNSIGNED_BYTE, MusicBuffer
	pop eax ; glCreateShaderProgramv
	FNCALL eax, GL_FRAGMENT_SHADER, 1, src_main
	FNCALL edi, eax

%if TOTAL_LOOPS > 1
%if TOTAL_LOOPS != 2
	%error "Not supported !"
%endif
	push esi
	mov ecx, TOTAL_SAMPLES * 1
	mov esi, MusicBuffer
	lea edi, [esi + ecx*4]
	rep movsd
	pop esi
%endif

	;
	; Play music
	;
	FNCALL waveOutOpen, waveout, byte -1, wavefmt, ZERO, ZERO, ZERO
	FNCALL waveOutWrite, dword [waveout], wavehdr, wavehdr_size

	;
	; Main loop
	;
	.mainloop:
		;
		; Query position of music & terminate if reached end
		;
		FNCALL waveOutGetPosition, dword [waveout], mmtime, 12
		mov ebx, dword [mmtime + 4]
		shr ebx, 2 ; divide by 4 (sizeof(SAMPLE) * nChannels) to get #samples
		cmp ebx, TOTAL_SAMPLES * TOTAL_LOOPS
		jge .exit
		
		;
		; Use main shader
		;
		FNCALL wglGetProcAddress, glUniform1i
		FNCALL eax, ZERO, ebx
		FNCALL glRects, byte -1, byte -1, byte 1, byte 1

		;
		; Swap, process messages & look at ESC key
		;
		FNCALL SwapBuffers, esi ; esi = HDC 
		FNCALL PeekMessageA, ZERO, ZERO, ZERO, ZERO, 1 ; PM_REMOVE = 1
		FNCALL GetAsyncKeyState, 27 ; VK_ESCAPE = 27
	jz .mainloop
.exit:
	call ExitProcess
