;
; (c)MX^Addict
;

;
; WinAPI import
;
%macro WINAPI_FUNC 2
	extern __imp__ %+ %1 %+ @ %+ %2
	%define %1 [__imp__ %+ %1 %+ @ %+ %2]
%endmacro

;
; OpenGL import
;
%macro GL_FUNC 2
;section _ %+ %1 data align=1
section _ %+ %2 data align=1
%1:
%defstr %[%1 %+ __str] %1
	db %1 %+ __str, 0
%endmacro

;
; OpenGL constants
;
GL_TEXTURE_2D 		  EQU 0x0de1
GL_FRAGMENT_SHADER    EQU 0x8b30
GL_LINEAR 			  EQU 0x2601
GL_TEXTURE_MAG_FILTER EQU 0x2800
GL_TEXTURE_MIN_FILTER EQU 0x2801
GL_TEXTURE_WRAP_S	  EQU 0x2802
GL_TEXTURE_WRAP_T     EQU 0x2803
GL_CLAMP_TO_EDGE      EQU 0x812F
GL_NEAREST            EQU 0x2600
GL_TEXTURE0 		  EQU 0x84c0
GL_RGBA8 			  EQU 0x8058
GL_RGBA               EQU 0x1908
GL_RG				  EQU 0x8227
GL_RGBA32F            EQU 0x8814
GL_RG32F	          EQU 0x8230
GL_BYTE               EQU 0x1400
GL_UNSIGNED_BYTE      EQU 0x1401
GL_SHORT              EQU 0x1402
GL_UNSIGNED_SHORT     EQU 0x1403
GL_INT                EQU 0x1404
GL_UNSIGNED_INT       EQU 0x1405
GL_FLOAT              EQU 0x1406
GL_2_BYTES            EQU 0x1407
GL_3_BYTES            EQU 0x1408
GL_4_BYTES            EQU 0x1409
GL_DOUBLE             EQU 0x140A
GL_FRAMEBUFFER        EQU 0x8D40
GL_COLOR_ATTACHMENT0  EQU 0x8CE0
GL_ALL_ATTRIB_BITS    EQU 0x000fffff

;
; WinAPI functions imports
;
%ifdef FULLSCREEN
WINAPI_FUNC ChangeDisplaySettingsA, 8
WINAPI_FUNC ShowCursor, 4
%endif

WINAPI_FUNC CreateWindowExA, 48
WINAPI_FUNC GetDC, 4
WINAPI_FUNC ChoosePixelFormat, 8
WINAPI_FUNC SetPixelFormat, 12
WINAPI_FUNC ExitProcess, 4
WINAPI_FUNC GetAsyncKeyState, 4
WINAPI_FUNC PeekMessageA, 20
WINAPI_FUNC SwapBuffers, 4
WINAPI_FUNC waveOutGetPosition, 12
WINAPI_FUNC waveOutOpen, 24
WINAPI_FUNC waveOutWrite, 12
WINAPI_FUNC wglCreateContext, 4
WINAPI_FUNC wglMakeCurrent, 8
WINAPI_FUNC wglGetProcAddress, 4
WINAPI_FUNC glRects, 16
WINAPI_FUNC glReadPixels, 28

GL_FUNC glCreateShaderProgramv, crtshp
GL_FUNC glUseProgram, useprg
GL_FUNC glUniform1i, unif1i

;
; WinAPI function caller
;
%macro FNCALL 1-*
	%rep %0-1
		%rotate -1
		push %1
	%endrep
	%rotate -1
	call %1
%endmacro
