/**
	Ghostbyte TV Noise by Frostbyte of Artline Designs
	
	30b entry for the 32b oldschool compo at Lovebyte 2024

	An experiment to see if ghostbyte (a bug in VIC-II) can be utilised to generate somewhat
	realistic TV noise. It turns out, not really. But some noise is generated and the top and
	bottom borders are opened too in 30 bytes, so I suppose that's something.
 */

// The prg alone won't work correctly when loaded on real c64 with e.g. Ultimate cartridges,
// so if doing that, uncomment these next lines to generate a disk image and rum from it as usual.
// .disk [filename = "ghostbyte_noise.d64", name="FROSTBYTE OF ALD", id="2024"] {
// 	[name = "TVNOISE", type = "prg", segments = "Main"]
// }
// .segment Main []

* = ($302-28)
start:
	sei		// stop kernal from doing stuffs as it would break our border opening
	ldx #$fa	// first wait for rasterline $fa
!:	eor $dc04	// eor A with CIA#1 timer lo for some pseudo randomness
	sta $3fff	// Store to last byte of VIC bank, aka ghostbyte
	cpx $d012	// Wait for rasterline $fa or $ff
	bne !-
	sty $d011	// Store VIC-II screen control register settings
	tya
	eor #($09^$01)	// Toggle VIC-II screen control register settings
	tay
	txa
	eor #($fa^$ff)	// Toggle rasterline to wait for between $fa and $ff
	tax
	bne !-
	jmp start 	// address overwrites basic loop idle vector, hence autostart