;	LumberJack in only 256 bytes
; 	Coded by Ko-Ko in 2024. e-mail: kolma.kornel@gmail.com
;	Commodore 64 version.
;
; 	If you like it, send me a real postcard just like in the good old days.
; 
; 	NAME:
;	Kornel Kolma (Ko-Ko)
;
; 	ADDRESS:
; 	Frigyes u. 10.
; 	Budapest
; 	H1039
; 	Hungary
;
;	DESCRIPTION:
;
;	HOW TO LOAD, START AND PLAY:
;	load "lumber256.prg",8,1
;	sys 4096
;	The game starts immediately. 


!to "lumber256.prg",cbm
*= $1000 					; sys 4096


branch		= $20			;1st branch 1st position -M
branchd		= $22			;1st branch 2nd position (+ 1 line)
branch2		= $24           ;2nd branch 1st position  M-
branchd2	= $26           ;2nd branch 2nd position (+ 1 line)
jack		= $28			;jack's head position
jackx		= $2a			;jack left / right positioning
bar			= $2b			;timer bar location
barl		= $2d			;timer bar length
bart		= $2e			;bar timer
ended		= $2f			;0 if game ended 


hpoint		= $0412+120			;score screen locations
mpoint		= $0413+120
lpoint		= $0414+120


keyporta 	= $dc02			;io column
keyportb 	= $dc03			;io row
keycol 		= $dc00 		;portA -> keyboard matrix column
keyrow 		= $dc01			;portB -> keyboard matrix row
getin		= $ffe4			;Kernal GETIN
clrscrn		= $e544
rasterline	= $d012
border		= $d020

init:
	jsr clrscrn				;-3 bytes
	
	lda #$30				; set points to 000
	sta lpoint
	sta mpoint
	sta hpoint
	
	lda #13					;init length of timer bar
	sta barl
	sta bar					;bar screen location at $xx13
	
	ldy #02					;init screen locations of the assets
	sty	branch
	sty jackx
	sty bart
	lda #42
	sta branchd
	lda #44
	sta branchd2
	lda #40*6
	sta jack
	ldx #04					;on C= +/4 this trick not gonna work!!! + 2 bytes
	stx branch2					
	stx bar+1				;bar loc $0410
	inx						;x = 05 now, so tree + branch location at $05xx			
	stx branch+1
	stx branchd+1
	stx branch2+1
	stx branchd2+1
	stx jack+1
	
	dey					;y was 2 now it's 1 
	sty ended			; game is running (y=1)
	ldx #$06			;was 7 before optimization
treeloop:
	clc
	tya
	adc #40
	tay
	lda #$66
	sta (branch),y			;draw the trunk
	dex
	bne treeloop
	

gameloop:
	ldy jackx
jackchar:					;drawjack
	lda #$6b				;1 char lumberjack
	sta (jack),y	
	jsr getin
	cmp #$41				;A pressed?
	bne noA
	lda #$6b				;set location and direction of jack to the left
	ldx #$02
	jsr keypressed
noA:
	cmp #$53				;S pressed?
	bne noS
	lda #$73				;set location and direction of jack to the right
	ldx #$04
	jsr keypressed
noS:

	lda ended
	bne nogameover
gameover:
	inc border
	jsr getin
	cmp #$20
	bne gameover
	; jmp init				;1 byte minus
	bpl init
nogameover:

	tay						;a=1 here, should be zero, but this means -1 byte again
	;ldy #0
fillbar:
	tya
	cmp barl
	bcc	paint
	lda #$2e				; no bar char ...
	; jmp nopaint			; -1 byte
	bcs nopaint
paint:
	lda #$62				; bar char
nopaint:
	sta (bar),y
	iny
	cpy #13					; must be the same as 'barl' init value
	bne fillbar
	
	; ldx #$00				
waitraster:
	cpx rasterline
	bne waitraster

	
	inc bart
	lda bart
	cmp #22					;bar decrease speed rate (the smaller the faster)
	bne nodecrease			;good playable rate is 22-24L
	stx bart				;reinit bar timer
	dec barl				;decrease bar length by 1 char
	bmi gameover		
nodecrease:
	;jmp gameloop
	bvc	 gameloop			;-1 byte

keypressed:
	sta jackchar+1
	stx jackx
	
	
	lda barl				;increment bar length on each cut
	cmp #13					;must be the same as 'barl' init value
	beq maxlength
	inc barl
maxlength:
	ldy #40*6
scrolldown:
	sec	
	tya
	sbc #40
	tay
	lda (branch),y
	sta (branchd),y
	lda (branch2),y
	sta (branchd2),y
	; cpy #$0				;1 byte minus (tya)
	tya						
	bne scrolldown
	; lda #$20				; clear first row
	; sta (branch),y
	; sta (branch2),y

	lda $dc04				;"random" number generator for the branches
	and #%00000011
	tay
	cmp #1
	beq nobranch
	cmp #3
	beq nobranch
	lda #$71				;branch char, y=0 -> left branch, y=2 -> right branch
	sta (branchd),y			;this was "branch" originally 
nobranch:

	ldy jackx				; collision check a.k.a. collision jack
	lda (jack),y
	cmp #$20
	beq nocollustion
	dec ended
nocollustion:

	inc lpoint				;a simplified 3-digit score system
	lda lpoint
	cmp #$3A		
	bne nonine
	lda #$30				;reset low point to '0'
	sta lpoint
	inc mpoint
	lda mpoint	
	cmp #$3A
	bne nonine
	lda #$30				;reset medium point to '0'
	sta mpoint
	inc hpoint
nonine:
	rts
