

;*       = $0801	; BASIC start up
;        .word (+), 0
;        .null $9e, format("%4d", main)
;+       .word 0

	GETIN = $FFE4
	PLOT = $E50C	; Kernal routine moves cursor to (y,x)
	CLS = $E544
	PRTNUM = $BDCD
	SAVE_XY = $FE2D
	RESTORE_XY = $FE27
	SAVE_XY_2 = $FE3C
	RESTORE_XY_2 = $FE36
	ADD_TO_ZP35 = $B699

	PNT = $d1	; Pointer to start of current screen line
	USER = $f3	; Pointer to colour memory of same
	TIME = $a0

	tmp = $2
	tile = $3
	rate = $4
	clock = $7	; NB: this gets wiped by PRTNUM
	axis = $14	; rely on SYS $xx22 to initialise
	dir = $b2	; defaults to #$3c
	score = $35
	
	left_col = 1
	right_col = 12
	bottom_row = 23

*=$822	; SYS 2082
main
	sta score+1	; zero out score
new_level
	jsr CLS      
new_tile
	ldx #0		; loop over each row
board	ldy #right_col+2 ; Indent score
	jsr PLOT	; Move cursor
	ldy #left_col
	sta (PNT),y	; paint left edge
	ldy #right_col
-	sta (PNT),y	; paint right edge
	dey
	beq print	; exit bottom row loop
	cpx #bottom_row	; draw the bottom row
	beq -
test	shx $d60d,y	; make some noise
	and (PNT),y	; look for full rows
	sta $d01f,y	; flash background
	dey
	bne test	; checked all blocks in row?
	inx		; inc row counter
	asl
	bcc board	; row is not full if any MSBs clear

; ***** full row, so scroll down  *****
	jsr scroll
	lda #100	; score 100 points for each full row
	jsr ADD_TO_ZP35
	bne new_tile	; always?
print
	ldx score
	lda score+1
	jsr PRTNUM	; print score

; ***** select a random tile  *****
-	ldx $dc04
	cpx #7
	bcs -
	lda tiles,x
	sta tile

; ***** position new tile *****
	ldy #(left_col+right_col)/2+1
	ldx #2		; Careful to not hit the top
loop
; ***** v-sync  *****
-	bit $d011
	bpl -

; **** check if we flagged a landing ****
	lda clock
	cmp rate
	bmi new_tile

; ***** erase tile  *****
erase	lda #32		; screencode for space
	sta tmp
	jsr draw_tile

; ***** backup tile location and orientation  *****
	jsr SAVE_XY
	ldx axis
	ldy dir
	jsr SAVE_XY_2

; ***** get key  *****
	jsr GETIN	; x & y are trashed
	jsr RESTORE_XY	; so restore them
                                          
; ***** gravity  *****
	inc clock	; tick clock here, gravity must preempt keys
	bpl down	; to avoid false landing detection

; ***** check keys  *****
	cmp #'s'	; is down ?
	bne +
down	inx
	lda TIME+1	; increments every 5.12 seconds
	and #63		; modulo 327.68 seconds
	beq new_level	; reset board after about 5 minutes 
	lsr
	adc #210
	sta rate	; until then, gradually increase speed
	sta clock
+	cmp #'d'	; is right ?
	bne +
	iny
+	cmp #'a'	; is left ?
	bne +
	dey
+	cmp #' '	; is Space bar?
	bne +

; ***** rotate tile  *****
	lda #$ff
	eor axis
	sta axis	; swap axes
	eor dir		; and invert one
	sta dir

; ***** check if new tile location is occupied *****
+	lda #$11	; opcode for ORA (zp),y
	jsr draw_tile_mod	; test new tile spot
	lda tmp		; tmp was previously set to 32
	cmp #32		; Did we only find spaces?
	beq draw	; okay to draw in new spot

; ***** already occupied, so invalid move *****
	jsr RESTORE_XY_2
	stx axis
	sty dir
	jsr RESTORE_XY
	dec clock	; if we just dropped then we have landed

; ***** draw tile in new position / orientation *****
draw	lda #$fa	;160
	sta tmp
	lda #$91	; opcode for STA (zp),y
	jsr draw_tile_mod
	beq loop	; always

tiles
;	+---+---+---+---+
;	| 1 | 2 | 3 | 4 |
;	+---+---+---+---+
;	| 0 |(7)| 6 | 5 |
;	+---+---+---+---+
;axis, dir
;$22, $c3  : %00100010, %11000011
;$dd, $1e  : %11011101, %00011110
;$22, $3c  : %00100010, %00111100
;$dd, $e1  : %11011101, %11100001

	.byte %11100001 ; I    ; E1 sbc (zp,x)  ; White 
	.byte %11000101 ; T    ; C5 cmp zp      ; Green 
	.byte %11001001 ; J    ; C9 cmp #       ; Brown 
	.byte %11000011 ; L    ; C3 dcp (zp,x)  ; Cyan 
	.byte %11000110 ; S    ; C6 dec zp      ; Dk Blue 
	.byte %11001100 ; O    ; CC cpy $       ; Grey 
;	.byte %10001101 ; Z    ; 8D sta $       ; Lt Green 
                                              
draw_tile_mod		; modify opcode to draw, or check occupancy
	sta mod_draw_op
	sta mod2
draw_tile
	lda #$80	; Start probing axis/dir/tile at MSB
	sta 650		; set keyboard autorepeat
check
	bit tile	; Does this tile exist here?
	beq nope
	pha		; A will get trashed, so save it
	jsr PLOT
	lda tmp
mod_draw_op
	sta (PNT),y
	sta tmp
	lda tile
mod2
	sta (USER),y	; tile data is also its colour
	pla		; restore A
nope
	bit axis	; check which axis to move along
	beq y_axis
x_axis
	bit dir		; check +ve or -ve along "x" axis
	beq minus_x
plus_x
	inx
	.byte $80	; NOP #, skip single byte opcode
minus_x
	dex
	bpl next_t	; always
y_axis
	bit dir		; check +ve or -ve along "y" axis
	beq minus_y
plus_y
	iny
	.byte $80	; NOP #, skip single byte opcode
minus_y
	dey
next_t	lsr		; Probe with next bit over
	bne check	; until there are no bits left
	rts
scroll
	pha		; adjust stack to satisfy kernal
	pha
	jsr $E98F	; kernal scroll down routine

