
org 100h

main:
    mov     ax, 3508h                   ; int 21h: ah = 35h get interrupt handler, al = 08h which interrupt
    int     21h                         ; returns the handler in es:bx
    push    es                          ; save the current handler to be able to restore it
    push    bx
    mov     al, 255
    out     40h, al                     ; write PIT counter divisor low byte
    mov     al, 0
    out     40h, al                     ; write PIT counter divisor high byte (freq = 1,19318181818 MHz / divisor)
    mov     dx, interrupt
    mov     ax, 2508h
    int     21h                         ; ah = 25h => set interrupt handler, al = which interrupt
.wait:
    jmp     .wait
    .exit equ $-1
    pop     dx
    pop     ds
    mov     ax, 2508h
    int     21h                         ; ah = 25h => set interrupt handler, al = which interrupt
    ret

interrupt:
    pusha
    push    ds                              ; practically only cs is guaranteed to be correct in interrupt
    push    cs                              ; so we save current ds and put ds = cs
    pop     ds
    test    word [counter2],0xFFFF
    jz      .playing
    mov     ax, [counter1]
    dec     ax
    jnz     .counting
    sub     word [counter2], 0x1FF
    mov     ax, word [counter2]
.counting:
    mov     word [counter1], ax
    cmp     ax, 0x40
    jl      .cont
    mov     ax, 0
.cont:
    mov     bx, 127
    mul     bx
    jmp     .sound
.playing:
    mov     ax, [time]
    mov     bx, melody
    shr     ax, 9
    xlat
    mul     word [time]
    inc     word [time]
    jnz     .sound
    mov     byte [main.exit], 0
.sound:
    test    ax, 0x200
    jz      .skip
    mov     al, 127
    jmp     .done
.skip:
    mov     al, 0
.done:
    mov     dx, 0378h                       ; LPT1 parallel port address for COVOX
    out     dx, al                          ; write 8 bit sample data
    pop     ds
    mov     al, 20h
    out     20h, al                         ; end of interrupt signal
    popa
    iret

    db 0,0,0,0,0

counter1:
    dw 0x3FE0

counter2:
    dw 0x3FE0

time:
    dw 0

; `12426  6  5     12425  5  4     12424   5 3  21   1 5   4      12426  6  5     12427   3 4  32 12424   5 3  21   1 5   4`
; [int(2 ** ([0, 2, 4, 5, 7, 9, 12][int(c)-1]/12)*128) if c >= '0' and c <= '9' else 0 for c in a]

melody:
    db 127, 142, 169, 142, 213, 0, 0, 213, 0, 0, 190, 0, 0, 0, 0, 0, 127, 142, 169, 142, 190, 0, 0, 190, 0, 0, 169, 0, 0, 0, 0, 0, 127, 142, 169, 142, 169, 0, 0, 0, 190, 0, 160, 0, 0, 142, 127, 0, 0, 0, 127, 0, 190, 0, 0, 0, 169, 0, 0, 0, 0, 0, 0, 127, 142, 169, 142, 213, 0, 0, 213, 0, 0, 190, 0, 0, 0, 0, 0, 127, 142, 169, 142, 254, 0, 0, 0, 160, 0, 169, 0, 0, 160, 142, 0, 127, 142, 169, 142, 169, 0, 0, 0, 190, 0, 160, 0, 0, 142, 127, 0, 0, 0, 127, 0, 190, 0, 0, 0, 169