;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Busy soft ;;; Pixondes 256 ;;; 30.01.2024 ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	USE32				;; Compiled in Flat assembler 1.71.39 
	ORG	0x400000

base	db	'MZbsPE',0,0		;; Signatures ( bs=busy soft:) ) 

;; COFF header ;;

	dw	0x014C			;; MZ+08 PE+04 Target Machine (Intel 386)
	dw	0			;; MZ+0A PE+06 NumberOfSections  

;;	dd	-1			;; MZ+0C PE+08 TimeDateStamp		UNUSED
;;	dd	-1			;; MZ+10 PE+0C PointerToSymbolTable	UNUSED
;;	dd	-1			;; MZ+14 PE+10 NumberOfSymbols		UNUSED

kus1:	mov	eax,[ebx+0x0C]		;; goto PEB_LDR_DATA ; EBX = PEB
	mov	eax,[eax+0x0C]		;; InLoadOrderModuleList
	mov	eax,[eax]		;; forward to next LIST_ENTRY
	mov	eax,[eax]		;; forward to next LIST_ENTRY
	jmp	ret1

	dw	8			;; MZ+18 PE+14 SizeOfOptionalHeader
	dw	0x0002			;; MZ+1A PE+16 Characteristics (2=executable)

;; Optional header ;;

	dw	0x010B			;; MZ+1C PE+18 Magic (PE 32bit EXE) 

;;	db	-1			;; MZ+1E PE+1A MajorLinkerVersion	UNUSED
;;	db	-1			;; MZ+1F PE+1B MinorLinkerVersion	UNUSED
;;	dd	-1			;; MZ+20 PE+1C SizeOfCode		UNUSED
;;	dd	-1			;; MZ+24 PE+20 SizeOfInitData		UNUSED
;;	dd	-1			;; MZ+28 PE+24 SizeOfUninitData		UNUSED
;;	dd	start - base		;; MZ+2C PE+28 AddressOfEntryPoint
;;	dd	-1			;; MZ+30 PE+2C BaseOfCode		UNUSED
;;	dd	-1			;; MZ+34 PE+30 BaseOfData		UNUSED  

kus2:	mov	eax,[ebx + 0x20]	;; EBX = name pointers table offset
	add	eax,ebp			;; EBX = name pointers table address
	mov	esi,[eax + ecx*4]	;; ESI = name pointer offset
	add	esi,ebp			;; ESI = name pointer address
	mov	eax,[ebx + 0x24]	;; EAX = ordinals table RVA offset

	db	0x3D			;; cmp eax,dword = skip address of entry point
	dd	start - base		;; MZ+2C PE+28 AddressOfEntryPoint

	add	eax,ebp			;; EAX = ordinals table RVA address
	movzx	edx,word [eax + ecx*2]	;; EDX = function ordinal
	jmp	sem2

;; Windows specific fields ;;

	dd	base			;; MZ+38 PE+34 ImageBase
	dd	4			;; MZ+3C PE+38 SectionAlignment => PE offset +4
	dd	4			;; MZ+40 PE+3C FileAlignment

;;	dw	-1			;; MZ+44 PE+40 MajorOperatingSystemVersion	UNUSED
;;	dw	-1			;; MZ+46 PE+42 MinorOperatingSystemVersion	UNUSED
;;	dw	-1			;; MZ+48 PE+44 MajorImageVersion		UNUSED
;;	dw	-1			;; MZ+4A PE+46 MinorImageVersion		UNUSED

sem3:	add	eax,[ebx + 0x1C]	;; EAX = address table RVA offset
	mov	edx,[eax + edx*4]	;; EDX = address of function RVA address
	jmp	ret2

	dw	4			;; MZ+4C PE+48 MajorSubsystemVersion

;;	dw	-1			;; MZ+4E PE+4A MinorSubsystemVersion		UNUSED
;;	dd	-1			;; MZ+50 PE+4C Win32VersionValue		UNUSED
;;	dd	bend - base		;; MZ+54 PE+50 SizeOfImage

start:	mov	edi,libzac-libdif	;; Entry point
	jmp	kus1			;; jmp argument = Low byte of image size in memory

	dw	((bend-base) shr 8) + 1	;; Next 3 bytes of image size in memory
	db	0

	dd	0x40			;; MZ+58 PE+54 SizeOfHeaders
;;	dd	-1			;; MZ+5C PE+58 CheckSum		UNUSED

sem2:	mov	eax,ebp			;; EAX = MZ header
	jmp	sem3

	dw	2			;; MZ+60 PE+5C Subsystem (Win32 GUI)
	dw	0			;; MZ+62 PE+5E DllCharacteristics  
;;	dd	0x04FFFF		;; MZ+64 PE+60 SizeOfStackReserve
;;	dd	0x04FFFF		;; MZ+68 PE+64 SizeOfStackCommit
;;	dd	0x04FFFF		;; MZ+6C PE+68 SizeOfHeapReserve
;;	dd	0x04FFFF		;; MZ+70 PE+6C SizeOfHeapCommit
;;	dd	-1			;; MZ+74 PE+70 LoaderFlags (must be 0)	UNUSED

;; Part of graphic effect code ;;

kus8:	shl	eax,1			;; MZ+64

	  add	  al,0			;; MZ+66  Each add al,0 = 04 00 = high word of stack/heap size

	shl	edx,1			;; MZ+68

	  add	  al,0			;; MZ+6A

	nop				;; MZ+6C
	push	ecx			;; MZ+6D

	  add	  al,0			;; MZ+6E

	push	ebx			;; MZ+70  SetPixel: Color
	push	eax			;; MZ+71  SetPixel: Y

	  add	  al,0			;; MZ+72

	push	edx			;; MZ+74  SetPixel: X
	push	edi			;; MZ+75  SetPixel: HDC
	jmp	ret8			;; MZ+76

	dd	0 			;; MZ+78 PE+74 NumberOfRvaAndSizes

;; End of all needed headers and continue resolving imports ;;

ret1:	mov	eax,[eax+0x18]		;; EAX = Kernel32 base memory

dlloop:	mov	ebp,eax			;; EAX = MZ header
	add	eax,[ebp + 0x3C]	;; EAX = PE header
	mov	ebx,[eax + 0x78]	;; EBX = exports directory table offset
	add	ebx,ebp			;; EBX = exports directory table address
	xor	ecx,ecx			;; ECX = 0. index of evaluated export

scnam:	jmp	kus2

ret2:	add	edx,ebp			; EDX = address of function abs address

	xor	eax,eax			; Make hash from function name
mkhash:	lodsb
	imul	eax,0x80501
	add	al,al
	jnz	mkhash
	shr	eax,0x16
	mov	dword [imports+eax*4],edx

	inc	ecx			; ECX = index of next function
	cmp	ecx,[ebx + 0x18]
	jnz	scnam

	add	edi,libdif		;; Move to next library name

	db	0xB8			;; B8 = mov eax,dword
	dd	0x00000000		;; MZ+B0 = zero = needed for WinXP  

	push	edi
	call	dword [LoadLibraryA]

	test	eax,eax
	jnz	dlloop

;; End of resolving imports and let's go to simple graphic effect ;;

	push	eax
	call	dword [GetDC]
	xchg	edi,eax			;; EDI = Device context of desktop

;; Main loop ;;

slucka:	push	0x7F			;; 127 pixels per 1 ms
	pop	ecx

efekt:	lea	ebx,[8*ebx+ebx+103]	;; EBX = Pseudorandom number

	movzx	eax,bh
	movzx	edx,bl
	jmp	kus8

ret8:	call	dword [SetPixelV]
	pop	ecx
	loop	efekt

;; Timing ;;

	push	1		; (Hint for optimize: SetPixelV returns 1 so push EAX is enough here)
	call	dword [Sleep]

;; Test ESC key ;;

	push	0x1B
	call	dword [GetAsyncKeyState]
	test	al,al
	jz	slucka
	retn

;; End of code ;;

libzac:
user32	db	'User32',0
gdi32	db	'Gdi32'
libdif	=	gdi32-user32

	db	0x010C + base - $ dup 0		;; Padding due to Windows 7+
	db	0x0200 + base - $ dup ?
imports	db	0x1000 dup ?
	db	0x0100 dup ?
bend:

;; Used imports ;;

Sleep		=	imports + 0x10C
GetDC		=	imports + 0xA10
SetPixelV	=	imports + 0xCC4
LoadLibraryA	=	imports + 0x4F0
GetAsyncKeyState =	imports + 0xD5C

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
