require("lualibs.common")
require("skilanderkit")
require("seppo")

print "hello from lua"

boardname = "newboard.map"

function initwaterfalls()
	waterwalls = {}

	for i = 0,numwalls()-1
	do
		if (wall_picnum(i) == 15) then
			--wall_yrepeat(i,2)
			table.insert(waterwalls, i)
		end
	end
end

function runwaterfalls()
	for _,i in pairs(waterwalls)
	do
		local newy = wall_ypanning(i) - wall_lotag(i)
		wall_ypanning(i, newy)
	end
end

tutorialdata = {
	{ false, "TUTORIAL1", "YOU MAY MOVE AROUND WITH ARROW KEYS.", ""},
	{ false, "TUTORIAL2", "HOLD UP TO SLIDE DOWN.",               "TAP UP TO GAIN MOMENTUM!"},
	{ false, "TUTORIAL3", "ICE IS SLIPPERY IN THIS WORLD,",       "WATCH OUT FOR DANGER!"},
	{ false, "TUTORIAL4", "BUILD UP SPEED AND",                   "USE THE RAMP TO GET ACROSS."},
	{ false, "TUTORIAL5", "JUMP WITH SPACE,",                     "TRY GETTING THAT COLLECTIBLE!"},
	{ false, "TUTORIAL6", "TAP UP REPEATEDLY TO GO UPHILL!",      "BACKSPACE TO RESTART LEVEL"},
	{ false, "TUTORIAL7", "THIS IS ALL I CAN TEACH YOU,",         "YOUR DESTINY IS IN YOUR HANDS!"},
}


function init(newinitpos, hotload)
	initpos = table_shallow_copy(newinitpos)

	print("wtf" .. dump(initpos) )
	print(string.format("init called! %f,%f,%f", initpos.x, initpos.y, initpos.z ) )
	if not hotload then
		mypos = table_shallow_copy(initpos)
	end

	-- collectibles
	for _,v in sprite_find_by_picnum(40) do
		sprite_xrepeat(v, 32)
		sprite_yrepeat(v, 25)
		sprite_statnum(v, 1)
	end

	-- killsprites
	killsectors = {}
	for _,v in sprite_find_by_picnum(41) do
		killsectors[ sprite_sectnum(v) ] = sprite_z(v)
		sprite_xrepeat(v, 0)
		sprite_yrepeat(v, 0)
	end


	initwaterfalls()

	setmusic(false)
	loadsong("music/skyunion.kdm")
	

	setfov(1.5)
	horiz = 100

	setsky(0)


	b_visibility(200)

	resetstate()

	music_playing = false

	g_winmap = 2

end

function silencemusic()
	setmusic(false)
	music_playing = false
end

function resetstate()
	onground = false
	
	onground_timer = 0 -- view shift
	
	vel = vec3(0,0,0)
	
	wantmoveang = 0
	
	jumptimer = 0
	
	pushtimer = 0
	makikotka = 0
	
	pushside = 0
	pushanimdir = 0
	pushanimdirv = 0
	
	grounddown = 0
	grounddownv = 0
	
	death = false
	grounddeath = false
	watertimer = 0
	makikotkazoom = 0.0
	
	tavarat=0
	tavaracount=0
	
	time=0.0
	curtime = 0
	
	floorshade = 0
	showSeppo = false

	mypos = table_shallow_copy(initpos)
	vel = vec3(0,0,0)
	print("beep!")
	alkueffu = 0

	racetimer = 0
	racetimer_enable = false
	loppueffu = false
	death = false
	grounddeath = false
	watertimer = 0

	tavaracount = 0
	for _,v in sprite_find_by_statnum(1) do
		sprite_xrepeat(v, 32)
		sprite_yrepeat(v, 25)
		tavaracount = tavaracount + 1
	end

	tavarat=0

	floorshade = 0

	for i,v in ipairs(tutorialdata) do
		tutorialdata[i][1] = false
	end
	tutorialtag = 0
	tutorialechotag = 0
	tutorialechotime = 0
	tutorialechovolume = 0.4

	wsay("SPAWN.WAV",7936, 0.4, 0.4)
end

-- gets called every frame before drawrooms. returns a table with camera position
function frame()

	time = time + 1.0 / 60.0
	curtime = curtime + 1

	if (loppueffu and getkeystatus(0x1c) and not gotomode) then
		gotomode = 6

		if ( racetimer > 0 ) then
			g_wintimer = racetimer
			if (tavaracount > 0.0) then
				g_winstuff = 100.0 * tavarat / (tavaracount)
			else
				g_winstuff = 0.0
			end
		end
	end


	if (getkeystatus(1) and not gotomode) then
		gotomode = 0

	end

	turnspeed = 10
	speed = 10.0
	upspeed = 3
	if (getkeystatus(0x2a)) then
		--speed = 10
		turnspeed = 15
	end

	wantmoveangt = 0
	wantmoveup = 0

	angrad = mypos.ang * math.pi / 1024.0
	dirvec  = vec2(math.cos(angrad), math.sin(angrad))


	if (getkeystatus(0xcb)) then
		wantmoveangt = -turnspeed
	end

	if (getkeystatus(0xcd)) then
		wantmoveangt = turnspeed
	end



	if (getkeystatus(0x39) or getkeystatus(0x2f)) then
		jumptimer = math.min(50, jumptimer + 4)
	elseif (jumptimer > 0 and onground) then
		if ( sector_floorpicnum(mypos.sect) ~= 8 ) then -- not water ":D"
			wantmoveup = -jumptimer * 1.5
			wsay("JUMP",2900, 0.3, 0.3)
		end
		jumptimer = 0
	else
		jumptimer = 0
	end

	local acc = vec3(0,0,0)
	acc.z = wantmoveup + 1.8




	local curspeed = length(vel)
	--print( string.format("vel %.2f", curspeed))

	local forwardkey = getkeystatus(0xc8)
	local backkey = getkeystatus(0xd0)


	-- flight mode
	if (getkeystatus(0x3a)) then
		racetimer = racetimer + 66
		if (getkeystatus(0x1e)) then
			acc.z = acc.z -4
		end

		if (getkeystatus(0x2c)) then
			acc.z = acc.z + 4
		end

		if (forwardkey) then
			acc.x = acc.x + dirvec.x * 4
			acc.y = acc.y + dirvec.y * 4
		end
		if (backkey) then
			acc.x = acc.x + dirvec.x * -4
			acc.y = acc.y + dirvec.y * -4
		end

	end

	if (forwardkey) then
		if (pushtimer == 0 and curspeed < 190 and onground) then
			acc.x = acc.x + dirvec.x * speed
			acc.y = acc.y + dirvec.y * speed
			print("push!")
			wsay("SKI1.WAV",7936, 0.1, 0.1)
			pushtimer = math.max(30, curspeed * 2) * 2

			pushanimdirv = pushside * 20
			if (pushside == 1) then
				pushside = -1
			else
				pushside = 1
			end
		end
	else
		--pushtimer = math.min(10, pushtimer)
		pushtimer = pushtimer * 0.5
	end

	pushtimer = math.max(0, pushtimer - 1)

	if (backkey) then
		if (onground) then
			local dotti = math.abs( dot( dirvec, vec2( vel.x, vel.y ) ) )
			fwd = -speed * dotti * 0.001
			acc.x = acc.x + dirvec.x * fwd
			acc.y = acc.y + dirvec.y * fwd
		end

	end


	local makikotkat = 0
	if (forwardkey and curspeed > 40) then
		makikotkat = math.min(1.0, (curspeed-40)/10.0) -- be faster then holding keydown
		if (makikotkat > 0.9999) then
			--print("matti!")
		end
	end
	makikotka = makikotka * 0.9 + makikotkat * 0.1
	local makikotkaz = makikotka * 150




	if onground then
		--print("dl",dl)

		--vfx = vx * math.abs(dirx / dl)
		--vfy = vy * math.abs(diry / dl)
		--v_dir = vel.x * dirvec.c + vvel.y * diry
		local v_dir = dot(vec2(vel.x, vel.y), dirvec)
		local dir_dir = dot(dirvec, dirvec)
		local prop = v_dir / dir_dir

		vf = dirvec * prop


		turnspeedpreserveratio = 0.9

		if (sector_floorpicnum(mypos.sect) == 7 ) then 
			turnspeedpreserveratio = 0.999
		end

		velbefore = length(vec2(vel.x, vel.y))

		vel.x = vel.x * (turnspeedpreserveratio) + vf.x * (1.0 - turnspeedpreserveratio)
		vel.y = vel.y * (turnspeedpreserveratio) + vf.y * (1.0 - turnspeedpreserveratio)

		velafter = length(vec2(vel.x, vel.y))

		--print("veldiff", velbefore, velafter)
		veldiff = (velafter - velbefore)
		if (veldiff < -7) then
			wsay("SKI2.WAV",7936, -veldiff*0.03, -veldiff*0.03)
		end

		local slowdown = 0.993 + makikotka * 0.007

		--print(string.format("slowdown %.3f", slowdown))

		vel.x = vel.x * slowdown
		vel.y = vel.y * slowdown

		--vx = vx * 0.8
		--vy = vy * 0.8
		--vz = vz * 0.9
	else
		vel.x = vel.x
		vel.y = vel.y
	end


	vel = vel + acc
	vel.x = math.floor(vel.x*16384.0 + 0.5) / 16384.0
	vel.y = math.floor(vel.y*16384.0 + 0.5) / 16384.0
	--vel.z = math.floor(vel.z + 0.5)

	local newpos = vec3(0,0,0)

	newpos.x, newpos.y, newpos.z, newpos.sect, cliphit = clipmove(
		mypos.x, mypos.y, mypos.z, mypos.sect,
		vel.x, vel.y,
		128, 128, 128, 65537)
	newpos.z = newpos.z + vel.z

	if ( cliphit >= 49152) then
		print("cliphit! "..cliphit-49152)
	end

	--print("moved: "..vecstr(mypos).." to "..vecstr(newpos))

	local megavel = newpos - mypos
	--print(vecstr(vel).." vs. "..vecstr(megavel))
	
	--print("THIS IS THE FIRST CLIPHIT:"..cliphit)
	if (cliphit > 32768) then
		vel = megavel
	else
		--vel = vel + (megavel - vel)
		--print("velwalla "..vecstr(vel))
	end

	--print(vecstr(vel).." vs. "..vecstr(megavel))

	local lastongronud = onground
	onground = false

	local hit = false

	local normal3 = vec3(0,0,0)

	if (cliphit >= 32768 and cliphit < 49152) then
		wall = cliphit - 32768
		--print("hit "..cliphit..", hit wall "..wall)

		local wall2 = wall_point2(wall)

		local sp1 = vec2(wall_x(wall), wall_y(wall))
		local sp2 = vec2(wall_x(wall2), wall_y(wall2))

		local w = sp2 - sp1
		local normal = -normalize(vec2(-w.y, w.x))
		local pd = dot(sp1, normal)

		normal3 = normal3 + vec3(-normal.x, -normal.y, 0.0)

		hit = true
	end

	if true then
		local floorz = sector_floorz(newpos.sect)
		local floorheinum = sector_floorheinum(newpos.sect) / 4096.0
		local ceilz = sector_ceilingz(newpos.sect)
		local ceilheinum = sector_ceilingheinum(newpos.sect) / 4096.0

		local firstwall = sector_wallptr(newpos.sect)
		local nextwall = wall_point2(firstwall)

		local wp0 = vec2(wall_x(firstwall), wall_y(firstwall))
		local wp1 = vec2(wall_x(nextwall),  wall_y(nextwall))
		local wp0_to_wp1 = normalize(wp1 - wp0)
		local floornor = vec3(0,0,-1)
		floornor.x = -wp0_to_wp1.y * floorheinum
		floornor.y = wp0_to_wp1.x * floorheinum
		floornor = normalize(floornor)

		local ceilnor = vec3(0,0,1)
		ceilnor.x = wp0_to_wp1.y * ceilheinum
		ceilnor.y = -wp0_to_wp1.x * ceilheinum
		ceilnor = normalize(ceilnor)


		floordist = dot(vec3(wp0.x, wp0.y, floorz), floornor) + 750
		ceildist = dot(vec3(wp0.x, wp0.y, ceilz), ceilnor) + 200

		penefloor = -( dot(floornor, newpos) - floordist )
		peneceil = -( dot(ceilnor, newpos) - ceildist )
		--pene = math.max(penefloor, peneceil)
		pene = penefloor
		surfnor = floornor
		if (peneceil > penefloor) then
			pene = peneceil
			surfnor = ceilnor
		end

		--print("penefloor "..penefloor.." peneceil "..peneceil)

		if (pene > 0) then
			--newpos = newpos + floornor * pene
			pushdir = surfnor * pene

			newpos2 = vec3(0,0,0)

			newpos2.x, newpos2.y, newpos2.z, newpos2.sect, cliphit2 = clipmove(
			newpos.x, newpos.y, newpos.z, newpos.sect,
			pushdir.x, pushdir.y,
			128, 128, 128, 65537)

			if (cliphit2 > 0) then

				newpos.x = newpos2.x
				newpos.y = newpos2.y
				newpos.z = newpos.z + pushdir.z

				vel.x = newpos2.x - mypos.x
				vel.y = newpos2.y - mypos.y
				print("secondary hit?")
			else
				newpos.z = newpos.z + pushdir.z
			end

			normal3 = normal3 + surfnor
			hit = true
			if ( not lastongronud ) then
				grounddownv = math.min(pene * 0.3, 5.0)
				wsay("SKI2.WAV",7936, 0.1, 0.1)
				print("grounddownv")
			end
			--print("onground")
			onground = true

			if grounddeath then
				death = true
			end

		end

	end



	--print("before hit "..vecstr(vel).." vs. "..vecstr(megavel))

	if hit then
		normal3 = normalize(normal3)
		--local d = dot(normal, mypos) - pd
		--print("moi", d)


		local e = 0.1
		local j = -(1.0 + e)*dot(vel, normal3)
		local velfix = j * normal3

		vel = vel + velfix



	end

	--print("after hit "..vecstr(vel).." vs. "..vecstr(megavel))

	--print("draw roomz")

	mypos.x = newpos.x
	mypos.y = newpos.y
	mypos.z = newpos.z
	mypos.sect = newpos.sect

	turnratio = 0.03 + math.min(0.7, curspeed * 0.001)
	wantmoveang = wantmoveang * (1.0-turnratio) + wantmoveangt * turnratio
	mypos.ang = mypos.ang + wantmoveang





	local ceilz, _ , florz, _ = getzrange(mypos.x, mypos.y, mypos.z, mypos.sect,
		128, 65535)
	--print("ceil, flor", ceilz, florz)

	local mypos1 = table_shallow_copy(mypos)
	mypos1.x = mypos.x + dirvec.x *  128
	mypos1.y = mypos.y + dirvec.y *  128
	--mypos1.sect = updatesector(mypos1.x, mypos1.y, mypos1.sect)
	local _, _ , suksi_z1, _ = getzrange(mypos1.x, mypos1.y, mypos1.z, mypos1.sect, 64, 65535)
	local zdiff = suksi_z1 - florz


	if onground then
		onground_timer = 1
	else
		onground_timer = onground_timer - 1.66
	end

	local newhoriz = 100
	if onground_timer > 0.0 and math.abs(zdiff) < 200 then
		newhoriz = newhoriz - zdiff * 0.2 * onground_timer
		newhoriz = math.min( math.max( newhoriz, 50), 150)
	end


	horiz = horiz + (newhoriz - horiz) * 0.1

	local deathness = 0

	local floorpic = sector_floorpicnum(mypos.sect)
	if ( floorpic == 8 or floorpic == 200 ) then -- water

		local floorz = sector_floorz(mypos.sect)
		local playerz = mypos.z + 750 + 10
		
		if (playerz > floorz) then
			print("WATER "..floorz.." vs. "..playerz)
			deathness = 1
		end
	end



	if (sector_floorpicnum(mypos.sect) == 33 ) then -- lava
		local floorz = sector_floorz(mypos.sect)
		local playerz = mypos.z + 750 + 10
		
		if (playerz > floorz) then
			death = true
			deathness = 2
		end
	end

	if (deathness > 0) then
		watertimer = watertimer + deathness
	else
		watertimer = 0
	end

	if (watertimer > 10) then
		death = true
	end

	if (killsectors[mypos.sect]) then
		print("killsprite! plr", mypos.z, "sect", killsectors[mypos.sect])
		if mypos.z > killsectors[mypos.sect] then
			if not grounddeath then
				wsay("DEATH.WAV",3000, 0.4, 0.4)
			end
			grounddeath = true
		end
	end

	if racetimer == nil then
		racetimer = 0
		racetimer_enable = false
	end

	if racetimer_enable then
		racetimer = racetimer + 1.0 / 60.0
	end

	--print("collectibles")
	for _,v in sprite_find_by_statnum(1) do
		--sprite_y(v, sprite_y(v) - 1)
		sprpos = vec3(sprite_pos(v))
		local dist = length(sprpos - mypos)
		--print("collecticble", v, vecstr(sprpos), dist)
		if (dist < 1500.0 and sprite_xrepeat(v) > 0) then
--			sprite_delete(v)
			sprite_xrepeat(v, 0)
			sprite_yrepeat(v, 0)

			tavarat = tavarat + 1

			collecteffu = -1.0

			print("GOTCHA")
			wsay("YEAH.WAV",3072, 0.3, 0.3)
			racetimer = racetimer - 5
		end
	end


	runwaterfalls()


	--print("onground", onground)

	local zz = mypos.z + math.max(jumptimer * (4+makikotka*3), makikotkaz) + watertimer * 100

	--drawrooms(-6556, 2264.25, 35398, 2028, 100, 4)


--{ ["x"] = ,["z"] = 2264.25,["y"] = 35398,["sect"] = 4,["ang"] = 2028,}






	local viewpos = vec3(0,0,0)
	viewpos.ang = mypos.ang
	viewpos.x, viewpos.y, viewpos.z, viewpos.sect, cliphit = clipmove(
		mypos.x, mypos.y, mypos.z, mypos.sect,
		dirvec.y * pushanimdir, -dirvec.x * pushanimdir,
		128, 128, 128, 65537)

	--print(string.format("pushside %.2f %.2f", pushanimdir, pushanimdirv))

	pushanimdir = pushanimdir * 0.95 + pushanimdirv
	pushanimdirv = pushanimdirv * 0.9

	zz = zz + math.min(400,grounddown*10.0)


	grounddown = grounddown * 0.9 + grounddownv
	grounddownv = grounddownv * 0.9
	local grounddown2 = grounddown --math.min(50, grounddown)
	--print(viewpos.x, viewpos.y, zz, viewpos.ang, horiz, viewpos.sect)
	drawrooms(viewpos.x, viewpos.y, zz, viewpos.ang, horiz, viewpos.sect)
	drawmasks()

	local sec,csec = math.modf(racetimer)
	drawtimer(string.format("TIME %02d:%02d", sec, math.floor(csec*100)), 2, 20, 0.7, 0)
	drawtimer(string.format("STUFF %d/%d", tavarat, tavaracount), 2, 32, 0.7, 0)

	if ( (makikotka + math.random()*0.045) > 0.95) then
		--print("curspeed",curspeed)
		local zoomt = 0.25
		makikotkazoom = makikotkazoom + ( zoomt - makikotkazoom ) * 0.3
		makikotkazoom = makikotkazoom + math.sin(time * curspeed * 0.08) * 0.003
	else
		makikotkazoom = makikotkazoom * 0.7
	end


	if (makikotkazoom > 0.001) then
		rotatesprite( 310, 20, makikotkazoom, 0, 36,   2,0, 2,    0,0,1,1);
	end

	if ( not dither ) then
		dither = 0.0
	else
		dither = dither + 0.618035512321
		dither = dither - math.floor(dither)
	end

	local sblink = math.floor((jumptimer / 50.0)*2.0 + dither)


	local angm = wantmoveang * math.abs(wantmoveang) * 0.001

	local floorshadet = sector_floorshade(mypos.sect )
	floorshade = floorshade * 0.8 + floorshadet * 0.2

	local yy = math.max(157,157+math.abs(pushanimdir)*0.05+pushanimdir*0.03+grounddown2)+math.abs(wantmoveang)
	local rr = pushanimdir*0.0 + angm
	rotatesprite( 80, yy, 0.5, rr, 34,   floorshade,0, 2,    0,0,1,1);
	if (sblink == 1) then
		rotatesprite( 80, yy, 0.5, rr, 49,   floorshade,0, 2,    0,0,1,1);
	elseif (sblink == 2) then
		rotatesprite( 80, yy, 0.5, rr, 37,   floorshade,0, 2,    0,0,1,1);
	end
	local yy = math.max(157,157+math.abs(pushanimdir)*0.05-pushanimdir*0.03+grounddown2)+math.abs(wantmoveang)
	local rr = -pushanimdir*0.0 + angm + 0
	rotatesprite(240, yy, 0.5, rr, 35,   floorshade,0, 2,    0,0,1,1);
	if (sblink == 1) then
		rotatesprite(240, yy, 0.5, rr, 50,   floorshade,0, 2,    0,0,1,1);
	elseif (sblink == 2) then
		rotatesprite(240, yy, 0.5, rr, 38,   floorshade,0, 2,    0,0,1,1);
	end

	if (alkueffu == nil) then
		alkueffu = 0
	else
		alkueffu = alkueffu + 1
	end



	if (getkeystatus(0xe)) then
		silencemusic()
		wsay("SCRATCH.WAV",3072, 0.4, 0.4)

		resetstate()
	end


	if (death) then
		if not grounddeath then
			wsay("DEATH.WAV",3072, 0.4, 0.4)
		end
		resetstate()
	end



	if ( sector_hitag(mypos.sect) >= 1) then
		print("omg sector with hitag: ", sector_hitag(mypos.sect))

		tutorialtag = sector_hitag(mypos.sect)
		
		if not tutorialdata[ tutorialtag ][1] then
			print("just saying ", tutorialdata[ tutorialtag ][2])
			wsay(tutorialdata[ tutorialtag ][2],3072, 0.5, 0.5)
			tutorialdata[ tutorialtag ][1] = true

			tutorialechotag = tutorialtag
			tutorialechotime = 10
			tutorialechovolume = 0.15
		end

	end

	if (tutorialtag > 0) then
		drawtext(tutorialdata[ tutorialtag ][3], 5, 50, 0.5, 0, 16.0, 0)
		drawtext(tutorialdata[ tutorialtag ][4], 5, 59, 0.5, 0, 16.0, 0)
	end

	if (tutorialechotime > 0) then
		tutorialechotime = tutorialechotime - 1
		if (tutorialechotime == 0) then

			wsay(tutorialdata[ tutorialechotag ][2],3072, tutorialechovolume, tutorialechovolume)

			tutorialechovolume = tutorialechovolume * 0.5
			if ( tutorialechovolume > 0.05) then
				tutorialechotime = 20
			end
		end
	end





	if (alkueffu < 150 and not loppueffu) then
		rotatesprite(160, 100, alkueffu * 0.01, alkueffu*0.4, 75,   2,0, 2,    0,0,1,1);
		--loppueffu = true
	end

	if ( not racetimer_enable and sector_lotag(mypos.sect) == 1) then
		racetimer_enable = true
		racestart_timer = 100

		if (not music_playing) then
			setmusic(true)
			music_playing = true
		end

	elseif (sector_lotag(mypos.sect) == 2 and not loppueffu) then
		racetimer_enable = false
		alkueffu = 0
		loppueffu = true
		wsay("RACEOVER",3000, 0.5, 0.5)
	end

	if (racestart_timer and racestart_timer > 0) then
		if ( g_winmap == 1 ) then
			drawtimer("RELAXING TUTORIAL BEGIN", 0, 100, 1.0, 0)
		else
			drawtimer("RACE BEGIN", 100, 100, 1.0, 0)
		end
		racestart_timer = racestart_timer - 1
	end


	if (loppueffu) then
		rotatesprite(160, 100, 100 / (1.0+math.min(alkueffu*0.4,100)), 0, 75,   2,0, 2,    0,0,1,1);

		--rotatesprite(40, 100, 1, 0,   122,   2,0, 2,    0,0,1,1);
		--rotatesprite(55, 100, 1, 0,   110,   2,0, 2,    0,0,1,1);

		if ( g_winmap == 1 ) then
			drawtimer("TUTORIAL OVER", 100, 100, 1.0, 0)
		else
			drawtimer("RACE OVER", 120, 100, 1.0, 0)
		end
		drawtimer("PRESS ENTER WHEN DONE", 70, 130, 0.7, 0)

	end

	if (collecteffu and collecteffu < 2.0) then
		rotatesprite(160, 100 + collecteffu * 150.0, 1.0, 0, 75,   2,0, 2,    0,0,1,1);

		collecteffu = collecteffu + 0.1

		setEmotion(3, 4)
		showSeppo = true

		--rotatesprite(40, 100, 1, 0,   122,   2,0, 2,    0,0,1,1);
		--rotatesprite(55, 100, 1, 0,   110,   2,0, 2,    0,0,1,1);

		drawtimer("COLLECTABLE COLLECTED", 10, 100, 1.0, 0)

	end

	if showSeppo then
		seppoDone = seppoEmotion(320, 150, 0.25, curtime)
		if (seppoDone == 0) then
			showSeppo = false
		end
	end

	--printtext(10,10, 40, -1, string.format("curspeed %.2f", curspeed), 0)
	--printtext(300,10, 40, -1, string.format("makikotka %.2f", makikotka), 0)
	--printtext(500,10, 40, -1, string.format("RACE: %.2f", racetimer), 0)


end
