#include scene_sessions24/util.glsl

vec2 hexagon_main(vec2 UV, float t) {
    float i_t = floor(t);
    float f_t = fract(t);

    vec2 p = UV;
    p*=rot(PI/6.0);
    p.y/=sqrt(3)/2.0;
    p.x+=p.y/2.0;

    vec2 i_p = floor(p*1.5);
    vec2 f_p = fract(p*1.5);

    vec3 id = vec3(i_p, step(f_p.x-f_p.y,0.0));
    if(id.z>0.5){
        if(mod(id.x+id.y,3.0)<0.5){
            id.x -= 1.0;
        }
        else if(mod(id.x+id.y,3.0)>1.5){
            id.y += 1.0;
        }
    }

    vec2 off = vec2(cos(rand(id.xy)),sin(rand(id.xy)));
    off = normalize(off)*0.2;

    return UV*rot(t)+off;
}