#include scene_sessions24/util.glsl

vec2 spiral_main(vec2 UV, float t) {
    float i_t = floor(t);
    float f_t = fract(t);

    vec2 p = UV;

    float div = float(3);
    float dir = mix(sine_ease(f_t)*2.-1., -sine_ease(f_t)*2.+1., step(1.,mod(i_t, 2.0)));
    float spiral = div*atan(p.y,p.x)/TAU+length(p)*dir+t;
    float i_spiral = fract(floor(spiral)/div)*div;
    
    vec2 n_p = vec2(length(p), i_spiral + fract(spiral));

    return n_p*vec2(1.5,2.0);
}