/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.devices.javasound;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;

public class MidiDeviceTools {
    public static void listDevices() {
        MidiDevice.Info[] infos;
        for (MidiDevice.Info info : infos = MidiSystem.getMidiDeviceInfo()) {
            System.out.println("MIDI Info: " + info.getDescription() + ", " + info.getName() + ", " + info.getVendor() + ", " + info.getVersion());
            try {
                MidiDevice device = MidiSystem.getMidiDevice(info);
                System.out.println("   Device: , #recv = " + device.getMaxReceivers() + ", #xmit = " + device.getMaxTransmitters() + ", open = " + device.isOpen() + ", " + device);
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
        }
    }

    public static MidiDevice findKeyboard(String text) {
        MidiDevice.Info[] infos;
        MidiDevice keyboard = null;
        for (MidiDevice.Info info : infos = MidiSystem.getMidiDeviceInfo()) {
            try {
                MidiDevice device = MidiSystem.getMidiDevice(info);
                if (device instanceof Synthesizer || device instanceof Sequencer || device.getMaxTransmitters() == 0 || text != null && !info.getDescription().toLowerCase().contains(text.toLowerCase())) continue;
                keyboard = device;
                System.out.println("Chose: " + info.getDescription());
                break;
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
        }
        return keyboard;
    }

    public static MidiDevice findKeyboard() {
        return MidiDeviceTools.findKeyboard(null);
    }
}

