/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.midi;

public class MidiConstants {
    public static final int MAX_CHANNELS = 16;
    public static final int NOTE_OFF = 128;
    public static final int NOTE_ON = 144;
    public static final int POLYPHONIC_AFTERTOUCH = 160;
    public static final int CONTROL_CHANGE = 176;
    public static final int PROGRAM_CHANGE = 192;
    public static final int CHANNEL_AFTERTOUCH = 208;
    public static final int CHANNEL_PRESSURE = 208;
    public static final int PITCH_BEND = 224;
    public static final int SYSTEM_COMMON = 240;
    public static final int PITCH_BEND_CENTER = 8192;
    public static final int CONTROLLER_BANK_SELECT = 0;
    public static final int CONTROLLER_MOD_WHEEL = 1;
    public static final int CONTROLLER_BREATH = 2;
    public static final int CONTROLLER_DATA_ENTRY = 6;
    public static final int CONTROLLER_VOLUME = 7;
    public static final int CONTROLLER_PAN = 10;
    public static final int CONTROLLER_LSB_OFFSET = 32;
    public static final int CONTROLLER_DATA_ENTRY_LSB = 38;
    public static final int CONTROLLER_TIMBRE = 74;
    public static final int CONTROLLER_DATA_INCREMENT = 96;
    public static final int CONTROLLER_DATA_DECREMENT = 97;
    public static final int CONTROLLER_NRPN_LSB = 98;
    public static final int CONTROLLER_NRPN_MSB = 99;
    public static final int CONTROLLER_RPN_LSB = 100;
    public static final int CONTROLLER_RPN_MSB = 101;
    public static final int RPN_BEND_RANGE = 0;
    public static final int RPN_FINE_TUNING = 1;
    public static final String[] PITCH_NAMES = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    static final double CONCERT_A_FREQUENCY = 440.0;
    static final double CONCERT_A_PITCH = 69.0;

    public static double convertPitchToFrequency(double pitch) {
        return 440.0 * Math.pow(2.0, (pitch - 69.0) / 12.0);
    }

    public static double convertFrequencyToPitch(double frequency) {
        return 69.0 + 12.0 * Math.log(frequency / 440.0) / Math.log(2.0);
    }
}

