/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.swing.DoubleBoundedRangeModel;
import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DoubleBoundedTextField
extends JTextField {
    private static final long serialVersionUID = 6882779668177620812L;
    boolean modified = false;
    int numCharacters;
    private DoubleBoundedRangeModel model;

    public DoubleBoundedTextField(DoubleBoundedRangeModel pModel, int numCharacters) {
        super(numCharacters);
        this.model = pModel;
        this.numCharacters = numCharacters;
        this.setHorizontalAlignment(10);
        this.setValue(this.model.getDoubleValue());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    DoubleBoundedTextField.this.model.setDoubleValue(DoubleBoundedTextField.this.getValue());
                } else {
                    DoubleBoundedTextField.this.markDirty();
                }
            }
        });
        this.model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DoubleBoundedTextField.this.setValue(DoubleBoundedTextField.this.model.getDoubleValue());
            }
        });
    }

    private void markDirty() {
        this.modified = true;
        this.setBackground(Color.pink);
        this.repaint();
    }

    private void markClean() {
        this.modified = false;
        this.setBackground(Color.white);
        this.setCaretPosition(0);
        this.repaint();
    }

    @Override
    public void setText(String text) {
        this.markDirty();
        super.setText(text);
    }

    private double getValue() throws NumberFormatException {
        double val = Double.valueOf(this.getText());
        this.markClean();
        return val;
    }

    private void setValue(double value) {
        super.setText(String.format("%6.4f", value));
        this.markClean();
    }
}

