/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitVariablePort;
import com.jsyn.unitgen.UnitFilter;

public class ContinuousRamp
extends UnitFilter {
    public UnitVariablePort current;
    public UnitInputPort time;
    private double previousInput = Double.MIN_VALUE;
    private double a;
    private double b;
    private double d;
    private int framesLeft;

    public ContinuousRamp() {
        this.time = new UnitInputPort(1, "Time", 1.0);
        this.addPort(this.time);
        this.current = new UnitVariablePort("Current");
        this.addPort(this.current);
    }

    @Override
    public void generate(int start, int limit) {
        double currentValue;
        double[] outputs = this.output.getValues();
        double[] inputs = this.input.getValues();
        double currentTime = this.time.getValues()[0];
        double inputValue = currentValue = this.current.getValue();
        for (int i = start; i < limit; ++i) {
            double x;
            inputValue = inputs[i];
            if (inputValue != this.previousInput) {
                x = this.framesLeft;
                double currentSlope = x * (3.0 * this.a * x + 2.0 * this.b);
                this.framesLeft = (int)((double)this.getSynthesisEngine().getFrameRate() * currentTime);
                if (this.framesLeft < 1) {
                    this.framesLeft = 1;
                }
                x = this.framesLeft;
                this.d = inputValue;
                double xsq = x * x;
                this.b = (3.0 * currentValue - currentSlope * x - 3.0 * this.d) / xsq;
                this.a = (currentSlope - 2.0 * this.b * x) / (3.0 * xsq);
                this.previousInput = inputValue;
            }
            if (this.framesLeft > 0) {
                x = --this.framesLeft;
                currentValue = x * (x * (x * this.a + this.b)) + this.d;
            }
            outputs[i] = currentValue;
        }
        this.current.setValue(currentValue);
    }
}

