/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.FilterBiquadCommon;

public class FilterPeakingEQ
extends FilterBiquadCommon {
    public UnitInputPort gain = new UnitInputPort("Gain", 1.0);
    private double previousGain;

    public FilterPeakingEQ() {
        this.addPort(this.gain);
    }

    @Override
    protected boolean isRecalculationNeeded(double frequencyValue, double qValue) {
        double currentGain = this.gain.getValues()[0];
        if (currentGain < 1.0E-5) {
            currentGain = 1.0E-5;
        }
        boolean needed = super.isRecalculationNeeded(frequencyValue, qValue);
        boolean bl = this.previousGain != currentGain;
        this.previousGain = currentGain;
        return needed |= bl;
    }

    @Override
    public void updateCoefficients() {
        double factorA = Math.sqrt(this.previousGain);
        double alphaTimesA = this.alpha * factorA;
        double alphaOverA = this.alpha / factorA;
        double scalar = 1.0 / (1.0 + alphaOverA);
        double a1_b1_value = -2.0 * this.cos_omega * scalar;
        this.a0 = (1.0 + alphaTimesA) * scalar;
        this.a1 = a1_b1_value;
        this.a2 = (1.0 - alphaTimesA) * scalar;
        this.b1 = a1_b1_value;
        this.b2 = (1.0 - alphaOverA) * scalar;
    }
}

