/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;

public class FourWayFade
extends UnitGenerator {
    public UnitInputPort input = new UnitInputPort(4, "Input");
    public UnitInputPort fade;
    public UnitOutputPort output;

    public FourWayFade() {
        this.addPort(this.input);
        this.fade = new UnitInputPort(2, "Fade");
        this.addPort(this.fade);
        this.output = new UnitOutputPort();
        this.addPort(this.output);
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputAs = this.input.getValues(0);
        double[] inputBs = this.input.getValues(1);
        double[] inputCs = this.input.getValues(2);
        double[] inputDs = this.input.getValues(3);
        double[] fadeLRs = this.fade.getValues(0);
        double[] fadeFBs = this.fade.getValues(1);
        double[] outputs = this.output.getValues(0);
        for (int i = start; i < limit; ++i) {
            double gainLR = fadeLRs[i] * 0.5 + 0.5;
            double temp = 1.0 - gainLR;
            double mixFront = inputAs[i] * temp + inputBs[i] * gainLR;
            double mixBack = inputDs[i] * temp + inputCs[i] * gainLR;
            double gainFB = fadeFBs[i] * 0.5 + 0.5;
            outputs[i] = mixBack * (1.0 - gainFB) + mixFront * gainFB;
        }
    }
}

