/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.unitgen.GrainEnvelope;
import com.jsyn.unitgen.GrainSource;

public class Grain
implements GrainEnvelope {
    private double frameRate;
    private double amplitude = 1.0;
    private GrainSource source;
    private GrainEnvelope envelope;

    public Grain(GrainSource source, GrainEnvelope envelope) {
        this.source = source;
        this.envelope = envelope;
    }

    @Override
    public double next() {
        if (this.envelope.hasMoreValues()) {
            double env = this.envelope.next();
            return this.source.next() * env * this.amplitude;
        }
        return 0.0;
    }

    @Override
    public boolean hasMoreValues() {
        return this.envelope.hasMoreValues();
    }

    @Override
    public void reset() {
        this.source.reset();
        this.envelope.reset();
    }

    public void setRate(double rate) {
        this.source.setRate(rate);
    }

    @Override
    public void setDuration(double duration) {
        this.envelope.setDuration(duration);
    }

    @Override
    public double getFrameRate() {
        return this.frameRate;
    }

    @Override
    public void setFrameRate(double frameRate) {
        this.frameRate = frameRate;
        this.source.setFrameRate(frameRate);
        this.envelope.setFrameRate(frameRate);
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(double amplitude) {
        this.amplitude = amplitude;
    }

    public GrainSource getSource() {
        return this.source;
    }
}

