/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.unitgen.UnitOscillator;

public class SawtoothOscillatorDPW
extends UnitOscillator {
    private static final double VERY_LOW_FREQUENCY = 4.535147392290249E-6;
    private double z1;
    private double z2;

    @Override
    public void generate(int start, int limit) {
        double[] frequencies = this.frequency.getValues();
        double[] amplitudes = this.amplitude.getValues();
        double[] outputs = this.output.getValues();
        double currentPhase = this.phase.getValue();
        for (int i = start; i < limit; ++i) {
            double phaseIncrement = this.convertFrequencyToPhaseIncrement(frequencies[i]);
            currentPhase = this.incrementWrapPhase(currentPhase, phaseIncrement);
            double squared = currentPhase * currentPhase;
            double diffed = squared - this.z2;
            this.z2 = this.z1;
            this.z1 = squared;
            double pinc = phaseIncrement;
            if (pinc < 0.0) {
                pinc = 0.0 - pinc;
            }
            double dpw = pinc < 4.535147392290249E-6 ? currentPhase : diffed * 0.25 / pinc;
            outputs[i] = amplitudes[i] * dpw;
        }
        this.phase.setValue(currentPhase);
    }
}

