/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.data.FloatSample;
import com.jsyn.util.AudioSampleLoader;
import com.jsyn.util.SampleLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

class JavaSoundSampleLoader
implements AudioSampleLoader {
    JavaSoundSampleLoader() {
    }

    @Override
    public FloatSample loadFloatSample(File fileIn) throws IOException {
        try {
            return this.loadFloatSample(AudioSystem.getAudioInputStream(fileIn));
        }
        catch (UnsupportedAudioFileException e) {
            throw new IOException(e);
        }
    }

    @Override
    public FloatSample loadFloatSample(InputStream inputStream) throws IOException {
        try {
            return this.loadFloatSample(AudioSystem.getAudioInputStream(inputStream));
        }
        catch (UnsupportedAudioFileException e) {
            throw new IOException(e);
        }
    }

    @Override
    public FloatSample loadFloatSample(URL url) throws IOException {
        try {
            return this.loadFloatSample(AudioSystem.getAudioInputStream(url));
        }
        catch (UnsupportedAudioFileException e) {
            throw new IOException(e);
        }
    }

    private FloatSample loadFloatSample(AudioInputStream audioInputStream) throws IOException, UnsupportedAudioFileException {
        AudioFormat format;
        float[] floatData = null;
        FloatSample sample = null;
        int bytesPerFrame = audioInputStream.getFormat().getFrameSize();
        if (bytesPerFrame == -1) {
            bytesPerFrame = 1;
        }
        if ((format = audioInputStream.getFormat()).getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            floatData = this.loadSignedPCM(audioInputStream);
        }
        sample = new FloatSample(floatData, format.getChannels());
        sample.setFrameRate(format.getFrameRate());
        return sample;
    }

    private float[] loadSignedPCM(AudioInputStream audioInputStream) throws IOException, UnsupportedAudioFileException {
        int totalSamplesRead = 0;
        AudioFormat format = audioInputStream.getFormat();
        int numFrames = (int)audioInputStream.getFrameLength();
        int numSamples = format.getChannels() * numFrames;
        float[] data = new float[numSamples];
        int bytesPerFrame = format.getFrameSize();
        int numBytes = 1024 * bytesPerFrame;
        byte[] audioBytes = new byte[numBytes];
        int numBytesRead = 0;
        int numFramesRead = 0;
        while ((numBytesRead = audioInputStream.read(audioBytes)) != -1) {
            int bytesRemainder = numBytesRead % bytesPerFrame;
            if (bytesRemainder != 0) {
                throw new IOException("Read partial block of sample data!");
            }
            if (audioInputStream.getFormat().getSampleSizeInBits() == 16) {
                if (format.isBigEndian()) {
                    SampleLoader.decodeBigI16ToF32(audioBytes, 0, numBytesRead, data, totalSamplesRead);
                } else {
                    SampleLoader.decodeLittleI16ToF32(audioBytes, 0, numBytesRead, data, totalSamplesRead);
                }
            } else if (audioInputStream.getFormat().getSampleSizeInBits() == 24) {
                if (format.isBigEndian()) {
                    SampleLoader.decodeBigI24ToF32(audioBytes, 0, numBytesRead, data, totalSamplesRead);
                } else {
                    SampleLoader.decodeLittleI24ToF32(audioBytes, 0, numBytesRead, data, totalSamplesRead);
                }
            } else if (audioInputStream.getFormat().getSampleSizeInBits() == 32) {
                if (format.isBigEndian()) {
                    SampleLoader.decodeBigI32ToF32(audioBytes, 0, numBytesRead, data, totalSamplesRead);
                } else {
                    SampleLoader.decodeLittleI32ToF32(audioBytes, 0, numBytesRead, data, totalSamplesRead);
                }
            } else {
                throw new UnsupportedAudioFileException("Only 16, 24 or 32 bit PCM samples supported.");
            }
            numFramesRead = numBytesRead / bytesPerFrame;
            totalSamplesRead += numFramesRead * format.getChannels();
        }
        return data;
    }
}

