/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.io.AudioOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class WaveFileWriter
implements AudioOutputStream {
    private static final short WAVE_FORMAT_PCM = 1;
    private OutputStream outputStream;
    private long riffSizePosition = 0L;
    private long dataSizePosition = 0L;
    private int frameRate = 44100;
    private int samplesPerFrame = 1;
    private int bitsPerSample = 16;
    private int bytesWritten;
    private File outputFile;
    private boolean headerWritten = false;
    private static final int PCM24_MIN = -8388608;
    private static final int PCM24_MAX = 0x7FFFFF;

    public WaveFileWriter(File outputFile) throws FileNotFoundException {
        this.outputFile = outputFile;
        FileOutputStream fileOut = new FileOutputStream(outputFile);
        this.outputStream = new BufferedOutputStream(fileOut);
    }

    public void setFrameRate(int frameRate) {
        this.frameRate = frameRate;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setSamplesPerFrame(int samplesPerFrame) {
        this.samplesPerFrame = samplesPerFrame;
    }

    public int getSamplesPerFrame() {
        return this.samplesPerFrame;
    }

    public void setBitsPerSample(int bits) {
        if (bits != 16 && bits != 24) {
            throw new IllegalArgumentException("Only 16 or 24 bits per sample allowed. Not " + bits);
        }
        this.bitsPerSample = bits;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
        this.fixSizes();
    }

    @Override
    public void write(double[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(float[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(double value) throws IOException {
        if (!this.headerWritten) {
            this.writeHeader();
        }
        if (this.bitsPerSample == 24) {
            this.writePCM24(value);
        } else {
            this.writePCM16(value);
        }
    }

    private void writePCM24(double value) throws IOException {
        double temp = 8388607.0 * value + 0.5 - -8388608.0;
        int sample = (int)temp + -8388608;
        if (sample > 0x7FFFFF) {
            sample = 0x7FFFFF;
        } else if (sample < -8388608) {
            sample = -8388608;
        }
        this.writeByte(sample);
        this.writeByte(sample >> 8);
        this.writeByte(sample >> 16);
    }

    private void writePCM16(double value) throws IOException {
        double temp = 32767.0 * value + 0.5 - -32768.0;
        int sample = (int)temp + Short.MIN_VALUE;
        if (sample > Short.MAX_VALUE) {
            sample = Short.MAX_VALUE;
        } else if (sample < Short.MIN_VALUE) {
            sample = Short.MIN_VALUE;
        }
        this.writeByte(sample);
        this.writeByte(sample >> 8);
    }

    @Override
    public void write(double[] buffer, int start, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.write(buffer[start + i]);
        }
    }

    public void write(float[] buffer, int start, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.write(buffer[start + i]);
        }
    }

    private void writeByte(int b) throws IOException {
        this.outputStream.write(b);
        ++this.bytesWritten;
    }

    public void writeIntLittle(int n) throws IOException {
        this.writeByte(n);
        this.writeByte(n >> 8);
        this.writeByte(n >> 16);
        this.writeByte(n >> 24);
    }

    public void writeShortLittle(short n) throws IOException {
        this.writeByte(n);
        this.writeByte(n >> 8);
    }

    private void writeHeader() throws IOException {
        this.writeRiffHeader();
        this.writeFormatChunk();
        this.writeDataChunkHeader();
        this.outputStream.flush();
        this.headerWritten = true;
    }

    private void writeRiffHeader() throws IOException {
        this.writeByte(82);
        this.writeByte(73);
        this.writeByte(70);
        this.writeByte(70);
        this.riffSizePosition = this.bytesWritten;
        this.writeIntLittle(Integer.MAX_VALUE);
        this.writeByte(87);
        this.writeByte(65);
        this.writeByte(86);
        this.writeByte(69);
    }

    public void writeFormatChunk() throws IOException {
        int bytesPerSample = (this.bitsPerSample + 7) / 8;
        this.writeByte(102);
        this.writeByte(109);
        this.writeByte(116);
        this.writeByte(32);
        this.writeIntLittle(16);
        this.writeShortLittle((short)1);
        this.writeShortLittle((short)this.samplesPerFrame);
        this.writeIntLittle(this.frameRate);
        this.writeIntLittle(this.frameRate * this.samplesPerFrame * bytesPerSample);
        this.writeShortLittle((short)(this.samplesPerFrame * bytesPerSample));
        this.writeShortLittle((short)this.bitsPerSample);
    }

    public void writeDataChunkHeader() throws IOException {
        this.writeByte(100);
        this.writeByte(97);
        this.writeByte(116);
        this.writeByte(97);
        this.dataSizePosition = this.bytesWritten;
        this.writeIntLittle(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixSizes() throws IOException {
        try (RandomAccessFile randomFile = new RandomAccessFile(this.outputFile, "rw");){
            long end = this.bytesWritten;
            int riffSize = (int)(end - this.riffSizePosition) - 4;
            randomFile.seek(this.riffSizePosition);
            this.writeRandomIntLittle(randomFile, riffSize);
            int dataSize = (int)(end - this.dataSizePosition) - 4;
            randomFile.seek(this.dataSizePosition);
            this.writeRandomIntLittle(randomFile, dataSize);
        }
    }

    private void writeRandomIntLittle(RandomAccessFile randomFile, int n) throws IOException {
        byte[] buffer = new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
        randomFile.write(buffer);
    }
}

