/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.math;

public class AudioMath {
    private static final double a2dScalar = 20.0 / Math.log(10.0);
    public static final int CONCERT_A_PITCH = 69;
    public static final double CONCERT_A_FREQUENCY = 440.0;
    private static double mConcertAFrequency = 440.0;

    public static double amplitudeToDecibels(double amplitude) {
        return Math.log(amplitude) * a2dScalar;
    }

    public static double decibelsToAmplitude(double decibels) {
        return Math.pow(10.0, decibels / 20.0);
    }

    public static double frequencyToPitch(double frequency) {
        return 69.0 + 12.0 * Math.log(frequency / mConcertAFrequency) / Math.log(2.0);
    }

    public static double pitchToFrequency(double pitch) {
        return mConcertAFrequency * Math.pow(2.0, (pitch - 69.0) * 0.08333333333333333);
    }

    public static void setConcertAFrequency(double concertAFrequency) {
        mConcertAFrequency = concertAFrequency;
    }

    public static double getConcertAFrequency() {
        return mConcertAFrequency;
    }

    public static double semitonesToFrequencyScaler(double semitones) {
        return Math.pow(2.0, semitones / 12.0);
    }
}

