/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.math;

import java.util.Vector;

public class Polynomial {
    private final Vector terms = new Vector();

    public Polynomial() {
    }

    public Polynomial(double c0) {
        this();
        this.appendTerm(c0);
    }

    public Polynomial(double c1, double c0) {
        this(c0);
        this.appendTerm(c1);
    }

    public Polynomial(double c2, double c1, double c0) {
        this(c1, c0);
        this.appendTerm(c2);
    }

    public Polynomial(double c3, double c2, double c1, double c0) {
        this(c2, c1, c0);
        this.appendTerm(c3);
    }

    public Polynomial(double c4, double c3, double c2, double c1, double c0) {
        this(c3, c2, c1, c0);
        this.appendTerm(c4);
    }

    public void appendTerm(double coefficient) {
        this.terms.addElement(new DoubleHolder(coefficient));
    }

    public void setTerm(double coefficient, int power) {
        int size = this.terms.size();
        if (power >= size) {
            for (int i = 0; i < power - size + 1; ++i) {
                this.appendTerm(0.0);
            }
        }
        ((DoubleHolder)this.terms.elementAt(power)).set(coefficient);
    }

    public void addTerm(double coefficient, int power) {
        this.setTerm(coefficient + this.get(power), power);
    }

    public double get(int power) {
        if (power >= this.terms.size()) {
            return 0.0;
        }
        return ((DoubleHolder)this.terms.elementAt(power)).get();
    }

    public int size() {
        return this.terms.size();
    }

    public static Polynomial plus(Polynomial p1, Polynomial p2) {
        Polynomial sum = new Polynomial();
        for (int i = 0; i < Math.max(p1.size(), p2.size()); ++i) {
            sum.appendTerm(p1.get(i) + p2.get(i));
        }
        return sum;
    }

    public static Polynomial minus(Polynomial p1, Polynomial p2) {
        Polynomial sum = new Polynomial();
        for (int i = 0; i < Math.max(p1.size(), p2.size()); ++i) {
            sum.appendTerm(p1.get(i) - p2.get(i));
        }
        return sum;
    }

    public static Polynomial mult(Polynomial p1, Polynomial p2) {
        Polynomial product = new Polynomial();
        for (int i = 0; i < p1.size(); ++i) {
            for (int j = 0; j < p2.size(); ++j) {
                product.addTerm(p1.get(i) * p2.get(j), i + j);
            }
        }
        return product;
    }

    public static Polynomial mult(double scaler, Polynomial p1) {
        Polynomial product = new Polynomial();
        for (int i = 0; i < p1.size(); ++i) {
            product.appendTerm(p1.get(i) * scaler);
        }
        return product;
    }

    public double evaluate(double x) {
        double result = 0.0;
        for (int i = 0; i < this.terms.size(); ++i) {
            result += this.get(i) * Math.pow(x, i);
        }
        return result;
    }

    public String toString() {
        String s = "";
        if (this.size() == 0) {
            s = "empty polynomial";
        }
        boolean somethingPrinted = false;
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.get(i) == 0.0) continue;
            if (somethingPrinted) {
                s = s + " + ";
            }
            String coeff = "";
            if (this.get(i) != 1.0 || i == 0) {
                coeff = coeff + this.get(i);
            }
            if (i == 0) {
                s = s + coeff;
            } else {
                String power = "";
                if (i != 1) {
                    power = "^" + i;
                }
                s = s + coeff + "x" + power;
            }
            somethingPrinted = true;
        }
        return s;
    }

    public static void main(String[] args) {
        Polynomial p1 = new Polynomial();
        System.out.println("p1=" + p1);
        Polynomial p2 = new Polynomial(3.0);
        System.out.println("p2=" + p2);
        Polynomial p3 = new Polynomial(2.0, 3.0);
        System.out.println("p3=" + p3);
        Polynomial p4 = new Polynomial(1.0, 2.0, 3.0);
        System.out.println("p4=" + p4);
        System.out.println("p4*5=" + Polynomial.mult(5.0, p4));
        System.out.println(p4.evaluate(10.0));
        System.out.println(Polynomial.plus(p4, p1));
        System.out.println(Polynomial.minus(p4, p3));
        p4.setTerm(12.2, 5);
        System.out.println(p4);
        p4.addTerm(0.8, 5);
        System.out.println(p4);
        p4.addTerm(0.8, 7);
        System.out.println(p4);
        System.out.println(Polynomial.mult(p3, p2));
        System.out.println(Polynomial.mult(p3, p3));
        System.out.println(Polynomial.mult(p2, p2));
        Polynomial t2 = new Polynomial(2.0, 0.0, -1.0);
        Polynomial t3 = new Polynomial(4.0, 0.0, -3.0, 0.0);
        Polynomial t4 = Polynomial.minus(Polynomial.mult(t3, new Polynomial(2.0, 0.0)), t2);
        System.out.println(t2 + "\n" + t3 + "\n" + t4);
    }

    static class DoubleHolder {
        double value;

        public DoubleHolder(double val) {
            this.value = val;
        }

        public double get() {
            return this.value;
        }

        public void set(double val) {
            this.value = val;
        }
    }
}

