/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.data.FloatSample;
import com.jsyn.data.HannWindow;
import com.jsyn.data.SequentialData;
import com.jsyn.data.SpectralWindow;
import com.jsyn.unitgen.FixedRateMonoWriter;
import java.util.Arrays;
import processing.sound.FFT;

class JSynFFT
extends FixedRateMonoWriter {
    private FloatSample buffer;
    private float[] real;
    private float[] imaginary;
    private SpectralWindow window;

    protected JSynFFT(int n) {
        this.buffer = new FloatSample(n);
        this.real = new float[n];
        this.imaginary = new float[n];
        this.window = new HannWindow(n);
        this.dataQueue.queueLoop((SequentialData)this.buffer);
    }

    protected void calculateMagnitudes(float[] fArray) {
        int n = (int)this.dataQueue.getFrameCount() % this.buffer.getNumFrames();
        this.buffer.read(n, this.real, 0, this.buffer.getNumFrames() - n);
        this.buffer.read(0, this.real, this.buffer.getNumFrames() - n, n);
        if (this.window != null) {
            for (int i = 0; i < this.real.length; ++i) {
                int n2 = i;
                this.real[n2] = (float)((double)this.real[n2] * this.window.get(i));
            }
        }
        Arrays.fill(this.imaginary, 0.0f);
        FFT.calculateMagnitudesFromSample(this.real, this.imaginary, fArray);
    }
}

