/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.unitgen.ChannelOut;
import java.util.stream.IntStream;
import processing.sound.Engine;
import processing.sound.Sound;
import processing.sound.SoundObject;

public abstract class MultiChannel {
    public static int autoSelectDevice(int n) {
        int[] nArray = IntStream.range(0, Sound.getAudioDeviceManager().getDeviceCount()).filter(n2 -> MultiChannel.availableChannels(n2) >= n).toArray();
        return Engine.getEngine().selectOutputDevice(nArray);
    }

    public static int autoSelectDevice() {
        int n2 = IntStream.range(0, Sound.getAudioDeviceManager().getDeviceCount()).map(n -> MultiChannel.availableChannels(n)).max().getAsInt();
        return MultiChannel.autoSelectDevice(n2);
    }

    public static int activeChannel(int n) {
        Engine.getEngine().selectOutputChannel(n);
        return MultiChannel.activeChannel();
    }

    public static int activeChannel() {
        return Engine.getEngine().outputChannel;
    }

    public static void connectToOutput(SoundObject soundObject, int n) {
        Engine.getEngine().connectToOutput(n, soundObject.circuit);
    }

    public static void disconnectFromOutput(SoundObject soundObject, int n) {
        Engine.getEngine().disconnectFromOutput(n, soundObject.circuit);
    }

    public static int availableChannels(int n) {
        return Engine.getAudioDeviceManager().getMaxOutputChannels(n);
    }

    public static int availableChannels() {
        return MultiChannel.availableChannels(Engine.getEngine().outputDevice);
    }

    public static ChannelOut[] outputs() {
        return Engine.getEngine().output;
    }

    public static boolean usePortAudio() {
        Engine engine = Engine.getEngine(null, true);
        try {
            if (engine.usePortAudio(true)) {
                engine.selectOutputDevice(-1);
            }
            return engine.isUsingPortAudio();
        }
        catch (RuntimeException runtimeException) {
            Engine.printError(runtimeException.getMessage());
            return engine.isUsingPortAudio();
        }
    }
}

