/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.data.FloatSample;
import com.jsyn.devices.AudioDeviceManager;
import com.jsyn.engine.SynthesisEngine;
import java.util.stream.IntStream;
import processing.core.PApplet;
import processing.sound.Engine;
import processing.sound.SoundFile;

public class Sound {
    public Sound(PApplet pApplet) {
        Engine.getEngine(pApplet);
    }

    public Sound(PApplet pApplet, int n, int n2, int n3, float f) {
        this(pApplet);
        Sound.sampleRate(n);
        Sound.inputDevice(n3);
        Sound.outputDevice(n2);
        Sound.volume(f);
    }

    public static AudioDeviceManager getAudioDeviceManager() {
        return Engine.getAudioDeviceManager();
    }

    public static String[] deviceNames() {
        String[] stringArray = new String[Sound.getAudioDeviceManager().getDeviceCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Engine.getEngine().getDeviceName(i);
        }
        return stringArray;
    }

    public static String[] list(String string) {
        String[] stringArray = Sound.deviceNames();
        System.out.println();
        Engine.printMessage(Sound.getAudioDeviceManager().getName() + " audio device search for '" + string + "'\n");
        Sound.printDeviceTable(IntStream.range(0, stringArray.length).filter(n -> stringArray[n].contains(string)).toArray());
        return stringArray;
    }

    public static String[] list() {
        return Sound.list(false);
    }

    public static String[] list(boolean bl) {
        String[] stringArray = Sound.deviceNames();
        AudioDeviceManager audioDeviceManager = Engine.getAudioDeviceManager();
        System.out.println();
        Engine.printMessage(audioDeviceManager.getName() + " device listing\n");
        if (bl) {
            Sound.printDeviceTable(IntStream.range(0, stringArray.length).toArray());
        } else {
            Sound.printDeviceTable(IntStream.range(0, stringArray.length).filter(n -> audioDeviceManager.getMaxInputChannels(n) > 0).toArray(), IntStream.range(0, stringArray.length).filter(n -> audioDeviceManager.getMaxOutputChannels(n) > 0).toArray());
        }
        return Sound.deviceNames();
    }

    private static int longestDeviceNameLength(int[] nArray) {
        int n = "Output device name".length();
        for (int n2 : nArray) {
            n = Math.max(n, Engine.getEngine().getDeviceName(n2).length());
        }
        return n;
    }

    private static String deviceNameTableDivider(int n) {
        return String.format("%" + (n + 2) + "s", "").replace(' ', '-');
    }

    private static void printDeviceTable(int[] nArray) {
        AudioDeviceManager audioDeviceManager = Sound.getAudioDeviceManager();
        int n = Sound.longestDeviceNameLength(nArray);
        String string = " %-3s %3s | %-" + n + "s | %6s | %4s%n";
        System.out.format(string, "", "id", "Device name", "inputs", "outputs");
        System.out.println("     ----+" + Sound.deviceNameTableDivider(n) + "+--------".repeat(2));
        for (int n2 : nArray) {
            Object[] objectArray = new Object[5];
            objectArray[0] = Engine.getEngine().inputDevice == n2 ? (Engine.getEngine().outputDevice == n2 ? "I,O" : "I") : (Engine.getEngine().outputDevice == n2 ? "O" : "");
            objectArray[1] = n2;
            objectArray[2] = Engine.getEngine().getDeviceName(n2);
            objectArray[3] = audioDeviceManager.getMaxInputChannels(n2);
            objectArray[4] = audioDeviceManager.getMaxOutputChannels(n2);
            System.out.format(string, objectArray);
        }
        System.out.println();
    }

    private static void printDeviceTable(int[] nArray, int[] nArray2) {
        AudioDeviceManager audioDeviceManager = Sound.getAudioDeviceManager();
        int n = Math.max(Sound.longestDeviceNameLength(nArray), Sound.longestDeviceNameLength(nArray2));
        String string = " %1s %3s | %-" + n + "s | %4s%n";
        System.out.format(string, " ", "id", "Input device name", "inputs");
        System.out.println("   ----+" + Sound.deviceNameTableDivider(n) + "+--------");
        for (int n2 : nArray) {
            System.out.format(string, Engine.getEngine().inputDevice == n2 ? "I" : " ", n2, Engine.getEngine().getDeviceName(n2), audioDeviceManager.getMaxInputChannels(n2));
        }
        System.out.println();
        System.out.format(string, " ", "id", "Output device name", "outputs");
        System.out.println("   ----+" + Sound.deviceNameTableDivider(n) + "+--------");
        for (int n2 : nArray2) {
            System.out.format(string, Engine.getEngine().outputDevice == n2 ? "O" : " ", n2, Engine.getEngine().getDeviceName(n2), audioDeviceManager.getMaxOutputChannels(n2));
        }
        System.out.println();
    }

    public static int sampleRate() {
        return Engine.getEngine().getSampleRate();
    }

    public static int sampleRate(int n) {
        Engine.getEngine().setSampleRate(n);
        return Sound.sampleRate();
    }

    public static int inputDevice(int n) {
        return Engine.getEngine().selectInputDevice(n);
    }

    public static int inputDevice(String string) {
        return Engine.getEngine().selectInputDevice(Engine.getEngine().getDeviceIdByName(string));
    }

    public static int outputDevice(int n) {
        return Engine.getEngine().selectOutputDevice(n);
    }

    public static int outputDevice(String string) {
        return Engine.getEngine().selectOutputDevice(Engine.getEngine().getDeviceIdByName(string));
    }

    public static int defaultOutputDevice() {
        return Sound.outputDevice(Engine.getAudioDeviceManager().getDefaultOutputDeviceID());
    }

    public static int defaultInputDevice() {
        return Sound.inputDevice(Engine.getAudioDeviceManager().getDefaultInputDeviceID());
    }

    public static void volume(float f) {
        Engine.getEngine().setVolume(f);
    }

    public static SynthesisEngine getSynthesisEngine() {
        return (SynthesisEngine)Engine.getEngine().synth;
    }

    public static void status() {
        SynthesisEngine synthesisEngine = Sound.getSynthesisEngine();
        Engine.println();
        Engine.printMessage("synthesis has been running for " + String.format("%.2f", synthesisEngine.getCurrentTime()) + " seconds, generated " + synthesisEngine.getFrameCount() + " frames (framerate " + synthesisEngine.getFrameRate() + ")");
        Engine.println("  audio devices used by " + synthesisEngine.getAudioDeviceManager().getName() + ":");
        if (Engine.getEngine().inputDevice != -1) {
            Engine.println("    input from '" + synthesisEngine.getAudioDeviceManager().getDeviceName(Engine.getEngine().inputDevice) + "': " + synthesisEngine.getAudioDeviceManager().getMaxInputChannels(Engine.getEngine().inputDevice) + " channels, latency " + Math.round(1000.0 * synthesisEngine.getInputLatency()) + "ms");
        }
        Engine.println("    output on '" + synthesisEngine.getAudioDeviceManager().getDeviceName(Engine.getEngine().outputDevice) + "': " + synthesisEngine.getAudioDeviceManager().getMaxOutputChannels(Engine.getEngine().outputDevice) + " channels, latency " + Math.round(1000.0 * synthesisEngine.getOutputLatency()) + "ms");
        Engine.println("\n  nodes in synthesizer network: " + Engine.getEngine().addedUnits.size());
        long l = 0L;
        for (FloatSample floatSample : SoundFile.SAMPLECACHE.values()) {
            l += (long)(floatSample.getNumFrames() * floatSample.getChannelsPerFrame());
        }
        Engine.println("  decoded audio samples held in cache: " + SoundFile.SAMPLECACHE.size() + " (" + l + " frames total)");
        Engine.println("  CPU usage: " + Math.round(100.0 * synthesisEngine.getUsage()) + "%");
        Engine.println();
    }

    public static void verbose(boolean bl) {
        Engine.verbose = bl;
    }

    public static void printConnections() {
        Sound.getSynthesisEngine().printConnections();
    }
}

