const std = @import("std");

pub fn build(b: *std.Build) void {
    const target = b.standardTargetOptions(.{});
    const optimize = b.standardOptimizeOption(.{});

    const dep__logu = b.dependency("logu", .{
        .target = target,
        .optimize = optimize,
    });
    const module__logu = dep__logu.module("logu");
    const dep__args = b.dependency("args", .{
        .target = target,
        .optimize = optimize,
    });
    const module__args = dep__args.module("args");

    const exe = b.addExecutable(.{
        .name = "gosia__gfx__cardemu",
        .root_source_file = b.path("src/main.zig"),
        .target = target,
        .optimize = optimize,
    });
    exe.root_module.addImport("logu", module__logu);
    exe.root_module.addImport("args", module__args);
    exe.linkLibC();
    exe.addLibraryPath(b.path("./swsim/build"));
    exe.addIncludePath(b.path("./swsim/include"));
    exe.addIncludePath(b.path("./swsim/lib/swicc/include"));
    exe.linkSystemLibrary("swsim");
    b.installArtifact(exe);

    const run_cmd = b.addRunArtifact(exe);
    run_cmd.step.dependOn(b.getInstallStep());
    if (b.args) |args| {
        run_cmd.addArgs(args);
    }
    const run_step = b.step("run", "Run the app");
    run_step.dependOn(&run_cmd.step);
    const exe_unit_tests = b.addTest(.{
        .root_source_file = b.path("src/main.zig"),
        .target = target,
        .optimize = optimize,
    });
    exe_unit_tests.root_module.addImport("logu", module__logu);
    exe_unit_tests.root_module.addImport("args", module__args);
    exe_unit_tests.linkLibC();
    exe_unit_tests.addLibraryPath(b.path("./swsim/build"));
    exe_unit_tests.addIncludePath(b.path("./swsim/include"));
    exe_unit_tests.addIncludePath(b.path("./swsim/lib/swicc/include"));
    exe_unit_tests.linkSystemLibrary("swsim");
    b.installArtifact(exe_unit_tests);

    const run_exe_unit_tests = b.addRunArtifact(exe_unit_tests);
    const test_step = b.step("test", "Run unit tests");
    test_step.dependOn(&run_exe_unit_tests.step);
}
