#version 450

#define FONT_BITS 8
#define FONT_FORMAT r8ui

noperspective layout(location = 0) in vec2 TexCoord;
noperspective layout(location = 1) in vec4 VertexColor;

layout(location = 0) out vec4 FragColor;

layout(set = 2, binding = 0, FONT_FORMAT) uniform readonly uimage2D u_FontTexture;

void main() {
    int x = int(TexCoord.x);
    ivec2 imagecoord = ivec2(x / FONT_BITS, TexCoord.y);
    uint font = imageLoad(u_FontTexture, imagecoord).r;

    int bitcoord = x % FONT_BITS;
    if (((font >> bitcoord) & 1u) == 0u) {
        discard;
    }

    FragColor = VertexColor;
}
