/* motherlist class, en generisk klasse til strenge-lister, af flower.
 * 
 * "motherlist" strukturen.
 * 
 * add(char *str, int i);	# tilfjer strengen str til listen med
 *				# index-# i.
 * char *get(int i);		# returnerer ptr til strengen i listen med
 * 				# index-# i.
 * char *pop();			# "popper" den frste streng i listen.
 * int count();			# tller antal af strenge i liste.
 *
 */

#include <stdlib.h>

class strlist {
	char *line;
	int index;
	strlist *next;
public:
	strlist(char *s,int i) {
		if (s!=NULL) {
			line=(char*)malloc(strlen(s)+1);
			strcpy(line,s);
		} else
			line=NULL;
		index=i;
		next=NULL;
	}
	~strlist() {
		free(line);
	}
	setnext(strlist *n) { next=n; }
	strlist *getnext() { return next; }
	char *getline() { return line; }
	int getindex() { return index; }
};

class motherlist {
	strlist *head,*tail;
	strlist *cur;
public:
	motherlist() {
		head=tail=NULL;
	}
	add(char *str,int i);
	char *get(int i);
	char *pop();
	int count();
	reset() { cur=head; }
	next() { if (cur!=NULL) cur=cur->getnext(); }
	char *peek() { if (cur!=NULL) return cur->getline(); }
	int last() { return (cur==NULL); }
};

motherlist::add(char *str,int i) {
	if ((str!=NULL)) {
		strlist *t=new strlist(str,i);
		if (head==NULL) 
			head=tail=t;
		else {
			tail->setnext(t);
			tail=t;
		}
	}
}

char *motherlist::get(int i) {
	strlist *t=head;
	char *r=NULL;

	while (t!=NULL) {
		if (t->getindex()==i) {
			r=t->getline();
		}
		t=t->getnext();
	}
	return r;
}

char *motherlist::pop() {
	strlist *t=head;
	char *r;
	
	if (head!=NULL) {
		if ((head->getline())!=NULL) {
			r=(char*)malloc(strlen(head->getline())+1);
			strcpy(r,head->getline());
			head=head->getnext();
			free(t);
			return r;
		}	
	} else
		return NULL;
}

int motherlist::count() {
	strlist *t=head;
	int i=0;

	while (t!=NULL) {
		i++;
		t=t->getnext();
	}
	return i;
}
