#ifdef WIN32
#define _WINDOWS 1
#undef UNIX
#endif
#include <sys/types.h>
#include <time.h>
#include <unistd.h>
#include <limits.h>
#ifdef _WINDOWS
#include <string.h>
#include <stdlib.h>
#include <io.h>
#include <windows.h>
#endif
#ifndef	DAYDREAM_H
#define	DAYDREAM_H	1

#ifdef _WINDOWS
#define strcasecmp stricmp
#define strncasecmp stricmpn
#endif

#ifdef OS2
#define strcasecmp stricmp
#define strncasecmp strncmp
#endif

#ifdef UNIX
#define DDTMP "/tmp/dd/"
#else
char DDTMP[256];
#endif


#ifndef PATH_MAX
#define PATH_MAX 512
#endif

#ifndef _WINDOWS
#define bint unsigned long long
#else
#define bint __int64
#endif

#ifdef _WINDOWS
#define pid_t int
#define uid_t int
#define gid_t int
#endif


#define UBYTE unsigned char
#define UWORD unsigned short
#ifndef _WINDOWS
#define ULONG unsigned int
#define BYTE char
#endif

#define versionstring "v2.04"

/* List / Node specifications - directly from AmigaOS :D */

struct savedflag {
	char fname[256];
	int  conf;
};

struct List {
	struct Node *lh_Head;
	struct Node *lh_Tail;
	struct Node *lh_TailPred;
};


struct Node {
	struct Node *ln_Succ;
	struct Node *ln_Pred;
};

struct FFlag {
	struct Node fhead;
	char   f_filename[256];
	char   f_path[PATH_MAX];
	ULONG  f_size;
	UWORD  f_conf;
	ULONG  f_flags;
};

struct dd_nodemessage {
	UWORD dn_command;
	ULONG dn_data1;
	ULONG dn_data2;
	ULONG dn_data3;
	char  dn_string[200];
};

#define JC_LIST (1L<<0)
#define JC_SHUTUP (1L<<1)
#define JC_QUICK  (1L<<2)

#define FLAG_FREE (1L<<0)

#define HOT_CURSOR (1L<<0)
#define HOT_YESNO  (1L<<1)
#define HOT_NOYES  (1L<<2)
#define HOT_QUICK  (1L<<3)
#define HOT_RE     (1L<<4)
#define HOT_DELAY  (1L<<5)
#define HOT_MAIN   (1L<<6)

#define PROMPT_SECRET (1L<<0)
#define PROMPT_NOCRLF (1L<<1)
#define PROMPT_FILE   (1L<<2)
#define PROMPT_WRAP   (1L<<3)
#define PROMPT_MAIN   (1L<<4)

#define TYPE_MAKE (1L<<0)
#define TYPE_WARN (1L<<1)
#define TYPE_NOCODES (1L<<2)
#define TYPE_CONF (1L<<3)
#define TYPE_NOSTRIP (1L<<4)
#define TYPE_SEC (1L<<5)

#define MC_QUICK (1L<<0)
#define MC_NOSTAT (1L<<1)

#define YELLDSOCK "/tmp/dd/yelld"
#define YELLDLOCK "/tmp/dd/yelld.lock"

struct lcfile {
	int lc_conf;
	char lc_name[256];
};

struct DayDream_NodeInfo
{
	pid_t ddn_pid;
	int   ddn_userslot;  /* -1 == no user on node */
	char  ddn_activity[80];
	int   ddn_bpsrate;
	char  ddn_pagereason[80];
	char  ddn_path[80];
	int   ddn_timeleft;
	int   ddn_flags;
};

struct DayDream_PageMsg
{
	UWORD pm_cmd;
	char  pm_string[300];
};

struct DayDream_MsgPointers
{
	UWORD  msp_low;
	UWORD  msp_high;
};

struct DayDream_LRP
{
	UWORD lrp_read;
	UWORD lrp_scan;
};

struct callerslog 
{
	UWORD cl_userid;
	time_t cl_firstcall; /* Just to be sure we have the right user */
	time_t cl_logon;
	time_t cl_logoff;
	ULONG  cl_ulbytes;
	ULONG  cl_dlbytes;
	UWORD  cl_ulfiles;
	UWORD  cl_dlfiles;
	UWORD  cl_pvtmessages;
	UWORD  cl_pubmessages;
	int    cl_bpsrate;
	int    cl_flags;
};


#define CL_CARRIERLOST (1L<<0)
#define CL_NEWUSER     (1L<<1)
#define CL_CHAT        (1L<<2)
#define CL_PASSWDFAIL  (1L<<3)
#define CL_PAGEDSYSOP  (1L<<4)
#define CL_RELOGIN     (1L<<5)

struct gcallerslog 
{
	UWORD cl_node;
	struct callerslog cl;
};

struct userbase
{
	char user_realname[26];
	char user_handle[26];
	char user_organization[26];
	char user_zipcity[21];
	char user_voicephone[21];
	UBYTE user_password[16];
	UBYTE user_screenlength;
	UBYTE user_protocol;
	ULONG	user_toggles;
	char user_signature[45];
	UBYTE	user_flines;
	bint	user_ulbytes; /* 64 bit ulbyte counter. Warez! */
	bint    user_dlbytes;
	UWORD	user_ulfiles;
	UWORD	user_dlfiles;
	UWORD	user_pubmessages;
	UWORD	user_pvtmessages;
	UWORD	user_connections;
	UBYTE	user_fileratio;
	UBYTE	user_byteratio;
	char user_computermodel[21];
	UBYTE	freeslot2;
	ULONG	user_freedlbytes;
	UBYTE	user_failedlogins;
	UBYTE	user_securitylevel;
	UBYTE	user_joinconference;
	UBYTE	freeslot3;
	time_t	user_firstcall;
	time_t	user_lastcall;
	ULONG	user_conferenceacc1;
	ULONG	user_conferenceacc2;
	UWORD	user_dailytimelimit;
	UWORD	user_account_id;
	UWORD	user_timeremaining;
	UWORD	user_freedlfiles;
	UWORD	user_fakedfiles;
	ULONG	user_fakedbytes;
	char  user_inetname[9];
	char 	user_freeblock[23];
};

/* user_toggles:
BIT  0:MEANING                    1:MEANING                  ON/OFF TOGGLES #1
==============================================================================
000  Line Editor                  Full Screen Editor
004  Novice User Mode             Expert User Mode
005  Personal Mail Check ON       Personal Mail Check Off
006  New Files Scan Off           New Files Scan On
008                               User has answered the NUQ
009  Allow nodemessages           Disallow nodemessages
010  CLS's in filelists	          No CLS's in filelists
011                               Ask FSEd/LineED
012                               Ask MailScan/NoMailScan
013                               Ask FileScan/NoFileScan
014                               Autoquick uploading
015  Background checker           Normal checker
...
030  Account Status #1 \ 0 = Active  0 = Frozen  1 = Deleted  1 = New Account
031  Account Status #2 / 0           1           0            1
==============================================================================
*/

struct DayDream_DoorMsg
{
	UWORD ddm_command;
	ULONG ddm_data1;
	ULONG ddm_data2;
	ULONG ddm_data3;
	bint ddm_ldata;
	char  ddm_string[300];
};

struct DayDream_Conference
{
  UBYTE	CONF_NUMBER;
  char CONF_NAME[40];
  char CONF_PATH[40];
  UBYTE	CONF_FILEAREAS;
  UBYTE	CONF_UPLOADAREA;
  UBYTE	CONF_MSGBASES;
  UBYTE	CONF_COMMENTAREA;
  UBYTE	CONF_UNUSED1;
  UWORD	CONF_ATTRIBUTES;
  char CONF_ULPATH[50];
  char CONF_NEWSCANAREAS[30];
  char CONF_PASSWD[16];
  char CONF_FREEBLOCK[116];
};

/* CONF_ATTRIBUTES:
BIT   MEANING WHEN SET AS PRESENTED BELOW                     CONFERENCE FLAGS
==============================================================================
000   FREE-DOWNLOAD ON ALL FILES IN THIS CONFERENCE
001   NO FILE OR BYTE CREDITS FOR UPLOADING
002   DISABLE SENT-BY LINES
003   34 CHARACTERS LONG FILENAMES
004   ASK DESTINATION FILE AREA
005   DO NOT ALLOW WILDCARDS IN FILENAMES (UPLOAD)
006   DO NOT ALLOW WILDCARD FILEFLAGGING
007   NO DUPECHECK (SKIP THIS CONF IN GLOBAL DUPE CHECK)
008   NO FILECHECK
010   PRIVATE FLAG -- DO NOT USE
 :
 :
 
 .
015
==============================================================================
*/

struct DayDream_MsgBase
{
  UBYTE	MSGBASE_FLAGS;
  UBYTE	MSGBASE_NUMBER;
  UWORD	MSGBASE_LOWEST;
  UWORD	MSGBASE_HIGHEST;
  UWORD	MSGBASE_MSGLIMIT;
  char MSGBASE_NAME[21];
  char MSGBASE_FREEBLOCK2[8];
  char MSGBASE_FN_TAG[26];
  char MSGBASE_FN_ORIGIN[58];
  UBYTE MSGBASE_FN_FLAGS;
  UWORD MSGBASE_FN_ZONE;
  UWORD MSGBASE_FN_NET;
  UWORD	MSGBASE_FN_NODE;
  UWORD	MSGBASE_FN_POINT;
  UBYTE	MSGBASE_READACCESS;
  UBYTE	MSGBASE_POSTACCESS;
  char MSGBASE_FREEBLOCK1[168];
};

/* MSGBASE_FLAGS:
BIT   MEANING WHEN SET AS PRESENTED BELOW                   MESSAGE BASE FLAGS
==============================================================================
 0    0: ALLOW PUBLIC MESSAGES         1: DO NOT ALLOW PUBLIC MESSAGES
 1    0: ALLOW PRIVATE MESSAGES        1: DO NOT ALLOW PRIVATE MESSAGES
 2    0: MESSAGES USE REAL NAMES       1: MESSAGES USE HANDLES / ALIASES
 3    0: QUOTE LINE AFTER ACTUAL QUOTE 1: USE THE "> " QUOTING METHOD
 4    0: A PLAIN "> " WILL DO          1: INSERT INITIALS BEFORE THE "> "
 5    0: DO NOT ALLOW FILE ATTACHS     1: ALLOW FILE ATTACHS
 7    PRIVATE FLAG -- DO NOT USE
==============================================================================
*/

struct DayDream_Message
{
  UWORD	MSG_NUMBER;
  UWORD	MSG_NEXTREPLY;
  UWORD	MSG_FLAGS;
  char MSG_AUTHOR[26];
  char MSG_RECEIVER[26];
  char MSG_SUBJECT[68];
  time_t MSG_CREATION;
  time_t MSG_RECEIVED;
  UWORD	MSG_READCOUNT;
  UWORD	MSG_ORIGINAL;
  char MSG_PASSWORD[16];
  UWORD	MSG_FN_PACKET_ORIG_ZONE;
  UWORD	MSG_FN_PACKET_ORIG_NET;
  UWORD	MSG_FN_PACKET_ORIG_NODE;
  UWORD	MSG_FN_PACKET_ORIG_POINT;
  UWORD	MSG_FN_ORIG_ZONE;
  UWORD	MSG_FN_ORIG_NET;
  UWORD	MSG_FN_ORIG_NODE;
  UWORD	MSG_FN_ORIG_POINT;
  ULONG	MSG_FN_MSGID;
  UWORD	MSG_FN_DEST_ZONE;
  UWORD	MSG_FN_DEST_NET;
  UWORD	MSG_FN_DEST_NODE;
  UWORD	MSG_FN_DEST_POINT;
  char MSG_ATTACH[33];
  char MSG_FREEBLOCK[85];
};

#define MSG_FLAGS_PRIVATE (1L<<0)
#define MSG_FLAGS_DELETED (1L<<1)

struct DayDream_Protocol
{
  UBYTE PROTOCOL_ID;
  char PROTOCOL_NAME[20];
  UBYTE PROTOCOL_EFFICIENCY;
  char PROTOCOL_XPRLIBRARY[30];
  char PROTOCOL_INITSTRING[30];
  UBYTE PROTOCOL_TYPE;
  char PROTOCOL_FREEBLOCK[117];
};


struct DayDream_DisplayMode
{
  UBYTE DISPLAY_ID;
  char DISPLAY_PATH[9];
  UWORD DISPLAY_ATTRIBUTES;
  UBYTE DISPLAY_INCOMING_TABLEID;
  UBYTE DISPLAY_OUTGOING_TABLEID;
  char DISPLAY_FONT[20];
  UWORD DISPLAY_FONTSIZE;
  UBYTE DISPLAY_STRINGS;
  char DISPLAY_FREEBLOCK[63];
};

/* DISPLAY_ATTRIBUTES:
==============================================================================
000   0: NO ANSI SUPPORT               1: ANSI CONTROL CODES ENABLED
001   0: NO INCOMING CONVERSION        1: ACTIVATE INCOMING CONVERSION
002   0: NO OUTGOING CONVERSION        1: ACTIVATE OUTGOING CONVERSION
003   0: NO CONVERSION IN FILES        1: ACTIVATE CONVERSION IN FILES
004   0: NO STRIP                      1: STRIP ANSICODES FROM TXT FILES
005   1: IF GFX DOESN'T EXIST, CHECK IF TXT DOES
 .
 .
015                                                                 
==============================================================================
*/

struct DayDream_AccessPreset
{
  UBYTE	ACCESS_SECLEVEL;
  UBYTE	ACCESS_PRESETID;
  UWORD	ACCESS_FREEFILES;
  ULONG	ACCESS_FREEBYTES;
  char ACCESS_DESCRIPTION[29];
  UBYTE	ACCESS_STATUS;
  char ACCESS_FREEBLOCK[12];
};

struct DayDream_MainConfig
{
  char	CFG_BOARDNAME[26];
  char	CFG_SYSOPNAME[26];
  UBYTE CFG_CHATMODE;
  UBYTE CFG_LOCALSCREEN;
  char	CFG_SERIALCODE[9];
  char	CFG_DEFAULTASCPATH[21];
  char	CFG_CHATDLPATH[41];
  UBYTE	CFG_DISPLAYMODE;
  ULONG	CFG_COPYBUFFER;
  UBYTE	CFG_JOINIFAUTOJOINFAILS;
  char	CFG_COLORSYSOP[11];
  char	CFG_COLORUSER[11];
  UBYTE	CFG_LINEEDCHAR;
  char	CFG_SYSTEMPW[16];
  char	CFG_NEWUSERPW[16];
  char	CFG_OLUSEREDPW[16];
  ULONG	CFG_UNIQUEMSGNUMBER;
  UBYTE	CFG_DIRFILEBUFFERSIZE;
  UBYTE	CFG_NEWUSERPRESETID;
  ULONG	CFG_IDLETIMEOUT;
  ULONG	CFG_FREEHDDSPACE;
  ULONG	CFG_FLAGS;
  char	CFG_SHELLPW[16];
  char  CFG_ALIENS[40];
  char  CFG_FSEDCOMMAND[71];
  char  CFG_FREEDLLINE[100];
  char  CFG_OLMS[41];
  UBYTE CFG_COSYSOPLEVEL;
  UBYTE CFG_CONTROLCODE;
  char  CFG_HOMES[40];
  UWORD CFG_GID;
  UWORD CFG_UID;
  char  CFG_CHATCMD[71];
  char  CFG_HOLDDIR[60];
  char  CFG_TELNETPAT[80];
  UBYTE   CFG_TELNET1ST;
  UBYTE   CFG_TELNETMAX;
  char  CFG_LOCALPAT[80];
  UBYTE   CFG_LOCAL1ST;
  UBYTE  CFG_LOCALMAX;
  uid_t CFG_BBSUID;
  gid_t CFG_BBSGID;
  int   CFG_DEFAULTS;
  int   CFG_MAXFTPUSERS;
  char	CFG_FREESLOT1[3154];

};

/* CFG_FLAGS:
BIT   MEANING WHEN SET AS PRESENTED BELOW                         SYSTEM FLAGS
==============================================================================
 0    0: DO NOT ASK CHAT REASON          1: ASK CHAT REASON
 1    0: REAL NAMES IN WHO ETC           1: HANDLES IN WHO ETC
 2    0: LOCATION IN WHO ETC             1: ORGANIZATION IN WHO ETC
 3    0: ENABLE WILDCARDS IN LOGON       1: DISABLE WILDCARDS IN LOGON
 4    0: QUESTIONAIRE ONLY FOR NEW USERS 1: ASK Q IF NOT ANSWERED YET
 6    0: $ ENTERS COMMAND MODE IN MSG-ED 1: CR ENTERS COMMAND MODE IN MSGED
 7    0: ASK REAL NAME FIRST (NEW USERS) 1: ASK HANDLE FIRST
 10   0: NORMAL DUPECHECKER              1: CATALOG DUPECHECKER
 11   0: NORMAL CHECKER                  1: BACKGROUND CHECKER
 * 
 ==============================================================================
*/

struct	DayDream_Multinode
{
  UBYTE	MULTI_NODE;
  UBYTE	MULTI_DEVICE;
  UWORD	MULTI_MINBAUD;
  UWORD	MULTI_MINBAUDNEW;
  ULONG MULTI_TTYSPEED;
  char	MULTI_TTYNAME[20];
  UWORD	MULTI_TTYTYPE;
  UBYTE	MULTI_SCREENFLAGS;
  UBYTE	MULTI_OTHERFLAGS;
  char	MULTI_COMMAND[32];
  BYTE	MULTI_PRIORITY;
  char	MULTI_TEMPORARY[33];
  ULONG MULTI_UNUSED;
  UBYTE MULTI_PEN5;
  UBYTE MULTI_PEN6;
  UBYTE MULTI_PEN7;
  UBYTE MULTI_PEN8;
  UBYTE MULTI_PEN9;
  UBYTE MULTI_PEN10;
  UBYTE MULTI_PEN11;
  UBYTE MULTI_PEN12;
  char	MULTI_FREE[88];
};

struct	DayDream_Archiver
{
  UBYTE	ARC_FLAGS;
  char	ARC_PATTERN[20];
  char	ARC_NAME[21];
  char	ARC_CMD_TEST[80];
  char	ARC_EXTRACTFILEID[80];
  char	ARC_ADDFILEID[80];
  char  ARC_VIEW[80];
  char	ARC_CORRUPTED1[16];
  char	ARC_CORRUPTED2[16];
  char	ARC_CORRUPTED3[16];
  UBYTE ARC_VIEWLEVEL;
  char	ARC_FREEBLOCK[3];
};

struct	DD_ExternalCommand
{
  char	EXT_NAME[11];
  UBYTE	EXT_CMDTYPE;
  UBYTE	EXT_SECLEVEL;
  char	EXT_COMMAND[87];
  ULONG  EXT_CONF1;
  ULONG  EXT_CONF2;
  char	EXT_FREEBLOCK1[92];
};

struct DD_Seclevel
{
  UBYTE	SEC_SECLEVEL;
  UBYTE	SEC_FILERATIO;
  UBYTE	SEC_BYTERATIO;
  UBYTE	SEC_PAGESPERCALL;
  UWORD	SEC_DAILYTIME;
  ULONG	SEC_CONFERENCEACC1;
  ULONG	SEC_CONFERENCEACC2;
  ULONG	SEC_ACCESSBITS1;
  ULONG	SEC_ACCESSBITS2;
  ULONG	SEC_ACCESSBITS3;
  ULONG	SEC_ACCESSBITS4;
  char	SEC_FREE[20];
};

struct DD_UploadLog
{
  UWORD UL_SLOT;
  char  UL_FILENAME[40];
  ULONG UL_FILESIZE;
  time_t UL_TIME;
  UWORD UL_BPSRATE;
  UBYTE UL_NODE;
  UBYTE UL_CONF;
  ULONG UL_FREE;
};

struct DD_DownloadLog
{
  UWORD DL_SLOT;
  char  DL_FILENAME[40];
  ULONG DL_FILESIZE;
  time_t DL_TIME;
  UWORD DL_BPSRATE;
  UBYTE DL_NODE;
  UBYTE DL_CONF;
  ULONG DL_FREE;
};

struct ftpinfo {
	pid_t pid;
	int userid;
	char filename[256];
	int filesize;
	int transferred;
	int cps;
	int mode;
};

#define SECB_DOWNLOAD			0
#define SECB_UPLOAD			1
#define SECB_READMSG			2
#define SECB_ENTERMSG			3
#define SECB_PAGE			4
#define SECB_COMMENT			5
#define SECB_BULLETINS			6
#define SECB_FILESCAN			7
#define SECB_NEWFILES			8
#define SECB_ZIPPYSEARCH		9
#define SECB_RUNDOOR			10
#define SECB_JOINCONF			11
#define SECB_CHANGEMSGAREA		12
#define SECB_CHANGEINFO			13
#define SECB_RELOGIN			14
#define SECB_TAGEDITOR			15
#define SECB_USERSTATS			16
#define SECB_VIEWTIME			17
#define SECB_HYDRATRANSFER		18
#define SECB_EXPERTMODE			19
#define SECB_EALLMESSAGE		20
#define SECB_FIDOMESSAGE		21
#define SECB_PUBLICMESSAGE		22
#define SECB_READALL			23
#define SECB_USERED			24
#define SECB_VIEWLOG			25
#define SECB_SYSOPDL			26
#define SECB_USERLIST			27
#define SECB_DELETEANY                  28
#define SECB_REMOTESHELL                29
#define SECB_WHO                        30
#define SECB_MOVEFILE			31

#define SECB_SELECTFILECONFS		0
#define SECB_SELECTMSGBASES		1
#define SECB_SENDNETMAIL        	2
#define SECB_OLM			3
#define SECB_PVTATTACH                  4
#define SECB_PUBATTACH                  5
#define SECB_VIEWFILE                   6
#define SECB_REALNAME                   7
#define SECB_HANDLE                     8

#endif
